/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.FileLocalStringEnumerator;
import com.intellij.psi.stubs.StubIdExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class StubForwardIndexExternalizer<StubKeySerializationState>
implements DataExternalizer<Map<StubIndexKey<?, ?>, Map<Object, StubIdList>>> {
    @ApiStatus.Internal
    public static final String USE_SHAREABLE_STUBS_PROP = "idea.uses.shareable.serialized.stubs";
    @ApiStatus.Internal
    public static final boolean USE_SHAREABLE_STUBS = Boolean.getBoolean("idea.uses.shareable.serialized.stubs");
    private final boolean useStableBinaryFormat;

    protected StubForwardIndexExternalizer() {
        this(false);
    }

    protected StubForwardIndexExternalizer(boolean useStableBinaryFormat) {
        this.useStableBinaryFormat = useStableBinaryFormat;
    }

    @NotNull
    private static <K> Map<K, StubIdList> deserializeIndexValue(@NotNull DataInput in, @NotNull StubIndexKey<K, ?> stubIndexKey, @Nullable K requestedKey) throws IOException {
        if (in == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(0);
        }
        if (stubIndexKey == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(1);
        }
        KeyDescriptor<K> keyDescriptor = StubIndexKeyDescriptorCache.INSTANCE.getKeyDescriptor(stubIndexKey);
        int bufferSize = DataInputOutputUtil.readINT((DataInput)in);
        byte[] buffer = new byte[bufferSize];
        in.readFully(buffer);
        UnsyncByteArrayInputStream indexIs = new UnsyncByteArrayInputStream(buffer);
        DataInputStream indexDis = new DataInputStream((InputStream)indexIs);
        HashingStrategy<K> hashingStrategy = StubIndexKeyDescriptorCache.INSTANCE.getKeyHashingStrategy(stubIndexKey);
        Map result = CollectionFactory.createCustomHashingStrategyMap(hashingStrategy);
        while (indexDis.available() > 0) {
            ProgressManager.checkCanceled();
            Object key = keyDescriptor.read((DataInput)indexDis);
            StubIdList read = StubIdExternalizer.INSTANCE.read(indexDis);
            if (requestedKey == null) {
                result.put(key, read);
                continue;
            }
            if (!hashingStrategy.equals(requestedKey, key)) continue;
            result.put(key, read);
            Map map = result;
            if (map == null) {
                StubForwardIndexExternalizer.$$$reportNull$$$0(2);
            }
            return map;
        }
        Map map = result;
        if (map == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public static StubForwardIndexExternalizer<?> getIdeUsedExternalizer() {
        if (!USE_SHAREABLE_STUBS) {
            return new IdeStubForwardIndexesExternalizer();
        }
        return new FileLocalStubForwardIndexExternalizer();
    }

    protected abstract StubKeySerializationState createStubIndexKeySerializationState(@NotNull DataOutput var1, @NotNull Set<StubIndexKey<?, ?>> var2) throws IOException;

    protected abstract void writeStubIndexKey(@NotNull DataOutput var1, @NotNull StubIndexKey var2, StubKeySerializationState var3) throws IOException;

    protected abstract StubKeySerializationState createStubIndexKeySerializationState(@NotNull DataInput var1, int var2) throws IOException;

    protected abstract ID<?, ?> readStubIndexKey(@NotNull DataInput var1, StubKeySerializationState var2) throws IOException;

    public final void save(@NotNull DataOutput out, @NotNull Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs) throws IOException {
        if (out == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(4);
        }
        if (indexedStubs == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(5);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)indexedStubs.size());
        if (!indexedStubs.isEmpty()) {
            StubKeySerializationState stubKeySerializationState = this.createStubIndexKeySerializationState(out, indexedStubs.keySet());
            Set<StubIndexKey<?, ?>> keysToStore = this.useStableBinaryFormat ? indexedStubs.keySet().stream().sorted(Comparator.comparing(IndexId::getName)).toList() : indexedStubs.keySet();
            for (StubIndexKey stubIndexKey : keysToStore) {
                this.writeStubIndexKey(out, stubIndexKey, stubKeySerializationState);
                Map<Object, StubIdList> map = indexedStubs.get(stubIndexKey);
                this.serializeIndexValue(out, stubIndexKey, map);
            }
        }
    }

    public final Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(6);
        }
        return this.doRead(in, null, null);
    }

    protected <K> Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> doRead(@NotNull DataInput in, @Nullable StubIndexKey<K, ?> requestedIndex, @Nullable K requestedKey) throws IOException {
        int stubIndicesValueMapSize;
        if (in == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(7);
        }
        if ((stubIndicesValueMapSize = DataInputOutputUtil.readINT((DataInput)in)) > 0) {
            HashMap stubIndicesValueMap = requestedIndex != null ? null : new HashMap(stubIndicesValueMapSize);
            StubKeySerializationState stubKeySerializationState = this.createStubIndexKeySerializationState(in, stubIndicesValueMapSize);
            for (int i = 0; i < stubIndicesValueMapSize; ++i) {
                ID<?, ?> indexKey = this.readStubIndexKey(in, stubKeySerializationState);
                if (indexKey instanceof StubIndexKey) {
                    boolean deserialize;
                    StubIndexKey stubIndexKey = (StubIndexKey)indexKey;
                    boolean bl = deserialize = requestedIndex == null || requestedIndex.equals((Object)stubIndexKey);
                    if (deserialize) {
                        Map<K, StubIdList> value = StubForwardIndexExternalizer.deserializeIndexValue(in, stubIndexKey, requestedKey);
                        if (requestedIndex != null) {
                            return Collections.singletonMap(requestedIndex, value);
                        }
                        stubIndicesValueMap.put(stubIndexKey, value);
                        continue;
                    }
                    StubForwardIndexExternalizer.skipIndexValue(in);
                    continue;
                }
                if (indexKey == null) {
                    StubForwardIndexExternalizer.skipIndexValue(in);
                    continue;
                }
                throw new AssertionError((Object)("indexKey '" + String.valueOf(indexKey) + "' [" + String.valueOf(indexKey.getClass()) + "] is not null, and not a StubIndexKey"));
            }
            return stubIndicesValueMap;
        }
        return Collections.emptyMap();
    }

    private <K> void serializeIndexValue(@NotNull DataOutput out, @NotNull StubIndexKey<K, ?> stubIndexKey, @NotNull Map<K, StubIdList> map) throws IOException {
        if (out == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(8);
        }
        if (stubIndexKey == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(9);
        }
        if (map == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(10);
        }
        KeyDescriptor<K> keyDescriptor = StubIndexKeyDescriptorCache.INSTANCE.getKeyDescriptor(stubIndexKey);
        BufferExposingByteArrayOutputStream indexOs = new BufferExposingByteArrayOutputStream();
        try (DataOutputStream indexDos = new DataOutputStream((OutputStream)indexOs);){
            Set<K> keysToStore = this.useStableBinaryFormat ? map.keySet().stream().sorted().toList() : map.keySet();
            for (Object key : keysToStore) {
                keyDescriptor.save((DataOutput)indexDos, key);
                StubIdList idsList = map.get(key);
                StubIdExternalizer.INSTANCE.save((DataOutput)indexDos, idsList);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)indexDos.size());
        }
        out.write(indexOs.getInternalBuffer(), 0, indexOs.size());
    }

    @NotNull
    public static StubForwardIndexExternalizer<?> createFileLocalExternalizer() {
        return new FileLocalStubForwardIndexExternalizer();
    }

    private static void skipIndexValue(@NotNull DataInput in) throws IOException {
        if (in == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(11);
        }
        int bufferSize = DataInputOutputUtil.readINT((DataInput)in);
        in.skipBytes(bufferSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexKey";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubForwardIndexExternalizer";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedStubs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubForwardIndexExternalizer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeIndexValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserializeIndexValue";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "serializeIndexValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "skipIndexValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class IdeStubForwardIndexesExternalizer
    extends StubForwardIndexExternalizer<Void> {
        private IdeStubForwardIndexesExternalizer() {
        }

        @Override
        protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, Void aVoid) throws IOException {
            if (out == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(0);
            }
            if (key == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(1);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)key.getUniqueId());
        }

        @Override
        protected Void createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey<?, ?>> set) {
            if (out == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(2);
            }
            if (set == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Override
        protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, Void aVoid) throws IOException {
            if (input == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(4);
            }
            return ID.findById((int)DataInputOutputUtil.readINT((DataInput)input));
        }

        @Override
        protected Void createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) {
            if (input == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(5);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/stubs/StubForwardIndexExternalizer$IdeStubForwardIndexesExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeStubIndexKey";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createStubIndexKeySerializationState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readStubIndexKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FileLocalStubForwardIndexExternalizer
    extends StubForwardIndexExternalizer<FileLocalStringEnumerator> {
        private FileLocalStubForwardIndexExternalizer() {
        }

        @Override
        protected FileLocalStringEnumerator createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey<?, ?>> set) throws IOException {
            if (out == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(0);
            }
            if (set == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(1);
            }
            FileLocalStringEnumerator enumerator = new FileLocalStringEnumerator(true);
            for (StubIndexKey<?, ?> key : set) {
                enumerator.enumerate(key.getName());
            }
            enumerator.write(out);
            return enumerator;
        }

        @Override
        protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, FileLocalStringEnumerator enumerator) throws IOException {
            if (out == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(2);
            }
            if (key == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(3);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)enumerator.enumerate(key.getName()));
        }

        @Override
        protected FileLocalStringEnumerator createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) throws IOException {
            if (input == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(4);
            }
            FileLocalStringEnumerator enumerator = new FileLocalStringEnumerator(false);
            enumerator.read(input);
            return enumerator;
        }

        @Override
        protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, FileLocalStringEnumerator enumerator) throws IOException {
            int idx;
            String name;
            if (input == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(5);
            }
            if ((name = enumerator.valueOf(idx = DataInputOutputUtil.readINT((DataInput)input))) == null) {
                throw new IOException("corrupted data: no value for idx = " + idx + " in local enumerator");
            }
            return ID.findByName((String)name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/stubs/StubForwardIndexExternalizer$FileLocalStubForwardIndexExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createStubIndexKeySerializationState";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeStubIndexKey";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readStubIndexKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

