/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.util.function.UnaryOperator;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service
@ApiStatus.Internal
public final class StubStringInterner
implements Disposable,
UnaryOperator<String> {
    private final LoadingCache<String, String> internCache = Caffeine.newBuilder().maximumSize(8192L).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault())).build(key -> key);

    static StubStringInterner getInstance() {
        return (StubStringInterner)ApplicationManager.getApplication().getService(StubStringInterner.class);
    }

    @VisibleForTesting
    public StubStringInterner() {
        LowMemoryWatcher.register(() -> this.internCache.invalidateAll(), (Disposable)this);
    }

    public void dispose() {
    }

    @Override
    @Nullable
    public String apply(@Nullable String s) {
        return s == null ? null : (String)this.internCache.get((Object)s);
    }
}

