/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.indexing.IndexFilterExcludingExtension;
import com.intellij.util.indexing.IndexedFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\t0\bH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/indexing/CustomizableExcludeExtensions;", "", "excludingExtensionEP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/util/indexing/IndexFilterExcludingExtension;", "<init>", "(Lcom/intellij/openapi/extensions/ExtensionPointName;)V", "excludingExtensions", "Lkotlin/Lazy;", "", "Lcom/intellij/openapi/fileTypes/FileType;", "", "createExcludeExtensionsLazyValue", "installListener", "", "hasExtensionForFileType", "", "fileType", "shouldExcludeFile", "file", "Lcom/intellij/util/indexing/IndexedFile;", "toString", "", "intellij.platform.indexing.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCustomizableExcludeExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomizableExcludeExtensions.kt\ncom/intellij/util/indexing/CustomizableExcludeExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,56:1\n1761#2,3:57\n1491#2:60\n1516#2,3:61\n1519#2,3:71\n382#3,7:64\n*S KotlinDebug\n*F\n+ 1 CustomizableExcludeExtensions.kt\ncom/intellij/util/indexing/CustomizableExcludeExtensions\n*L\n44#1:57,3\n25#1:60\n25#1:61,3\n25#1:71,3\n25#1:64,7\n*E\n"})
public final class CustomizableExcludeExtensions {
    @NotNull
    private final ExtensionPointName<IndexFilterExcludingExtension> excludingExtensionEP;
    @NotNull
    private volatile Lazy<? extends Map<FileType, ? extends List<? extends IndexFilterExcludingExtension>>> excludingExtensions;

    public CustomizableExcludeExtensions(@NotNull ExtensionPointName<IndexFilterExcludingExtension> excludingExtensionEP) {
        Intrinsics.checkNotNullParameter(excludingExtensionEP, (String)"excludingExtensionEP");
        this.excludingExtensionEP = excludingExtensionEP;
        this.excludingExtensions = this.createExcludeExtensionsLazyValue();
    }

    private final Lazy<Map<FileType, List<IndexFilterExcludingExtension>>> createExcludeExtensionsLazyValue() {
        return LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> CustomizableExcludeExtensions.createExcludeExtensionsLazyValue$lambda$0(this));
    }

    public final void installListener() {
        this.excludingExtensionEP.addChangeListener(() -> CustomizableExcludeExtensions.installListener$lambda$0(this), null);
    }

    public final boolean hasExtensionForFileType(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return ((Map)this.excludingExtensions.getValue()).containsKey(fileType);
    }

    public final boolean shouldExcludeFile(@NotNull IndexedFile file) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            List excludeExtensions = (List)((Map)this.excludingExtensions.getValue()).get(file.getFileType());
            if (excludeExtensions == null) {
                return false;
            }
            Iterable $this$any$iv = excludeExtensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IndexFilterExcludingExtension it = (IndexFilterExcludingExtension)element$iv;
                    boolean bl2 = false;
                    if (!it.shouldExclude(file)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(this.excludingExtensionEP)) {
            return "CustomizableExcludeExtensions(" + this.excludingExtensionEP.getExtensionList() + ")";
        }
        return "CustomizableExcludeExtensions(EP[" + this.excludingExtensionEP.getName() + "] is unresolved -> empty)";
    }

    /*
     * WARNING - void declaration
     */
    private static final Map createExcludeExtensionsLazyValue$lambda$0(CustomizableExcludeExtensions this$0) {
        Map map;
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(this$0.excludingExtensionEP)) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = this$0.excludingExtensionEP.getExtensionList();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                IndexFilterExcludingExtension it = (IndexFilterExcludingExtension)element$iv$iv;
                boolean bl = false;
                FileType key$iv$iv = it.getFileType();
                Map map2 = destination$iv$iv;
                FileType key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private static final void installListener$lambda$0(CustomizableExcludeExtensions this$0) {
        this$0.excludingExtensions = this$0.createExcludeExtensionsLazyValue();
    }
}

