/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.events.FileIndexingRequest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ProjectFilesCondition {
    private static final int MAX_FILES_TO_UPDATE_FROM_OTHER_PROJECT = 2;
    private final VirtualFile myRestrictedTo;
    private final GlobalSearchScope myFilter;
    private int myFilesFromOtherProjects;
    private final IdFilter myIndexableFilesFilter;

    public ProjectFilesCondition(IdFilter indexableFilesFilter, GlobalSearchScope filter, VirtualFile restrictedTo, boolean includeFilesFromOtherProjects) {
        this.myRestrictedTo = restrictedTo;
        this.myFilter = filter;
        this.myIndexableFilesFilter = indexableFilesFilter;
        if (!includeFilesFromOtherProjects) {
            this.myFilesFromOtherProjects = 2;
        }
    }

    private boolean acceptsFileAndId(VirtualFile file, int fileId) {
        if (this.myIndexableFilesFilter != null && !this.myIndexableFilesFilter.containsFileId(fileId)) {
            if (this.myFilesFromOtherProjects >= 2) {
                return false;
            }
            ++this.myFilesFromOtherProjects;
            return true;
        }
        if (FileBasedIndexEx.belongsToScope(file, this.myRestrictedTo, this.myFilter)) {
            return true;
        }
        if (this.myFilesFromOtherProjects < 2) {
            ++this.myFilesFromOtherProjects;
            return true;
        }
        return false;
    }

    public boolean acceptsFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (file instanceof VirtualFileWithId) {
            VirtualFileWithId fileWithId = (VirtualFileWithId)file;
            return this.acceptsFileAndId(file, fileWithId.getId());
        }
        return this.acceptsFileAndId(file, 0);
    }

    public boolean acceptsRequest(@NotNull FileIndexingRequest request) {
        if (request == null) {
            ProjectFilesCondition.$$$reportNull$$$0(0);
        }
        if (request.isDeleteRequest()) {
            return true;
        }
        return this.acceptsFileAndId(request.getFile(), request.getFileId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/indexing/ProjectFilesCondition", "acceptsRequest"));
    }
}

