/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CachedFileContent {
    private static final Logger LOG = Logger.getInstance(CachedFileContent.class);
    private final VirtualFile myVirtualFile;
    private byte[] myCachedBytes;
    private long myCachedTimeStamp;
    private Boolean myCachedWritable;

    public CachedFileContent(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CachedFileContent.$$$reportNull$$$0(0);
        }
        this.myCachedTimeStamp = -1L;
        this.myVirtualFile = virtualFile;
    }

    public byte @NotNull [] getBytes() throws IOException {
        if (this.myCachedBytes == null) {
            if (this.myVirtualFile.isValid()) {
                this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
                this.myCachedBytes = this.myVirtualFile.contentsToByteArray(false);
            } else {
                this.myCachedTimeStamp = -1L;
                this.myCachedBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
        }
        if (this.myCachedBytes == null) {
            CachedFileContent.$$$reportNull$$$0(1);
        }
        return this.myCachedBytes;
    }

    public byte @NotNull [] getBytesOrEmpty() {
        byte[] byArray;
        try {
            byArray = this.getBytes();
        }
        catch (IOException e) {
            if (IndexDebugProperties.DEBUG) {
                LOG.info("Failed to load content for file " + String.valueOf(this.myVirtualFile), (Throwable)e);
            }
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                CachedFileContent.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            CachedFileContent.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    public void setEmptyContent() {
        this.myCachedBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            CachedFileContent.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public long getTimeStamp() {
        if (this.myCachedTimeStamp == -1L) {
            this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
        }
        return this.myCachedTimeStamp;
    }

    public boolean isWritable() {
        if (this.myCachedWritable == null) {
            this.myCachedWritable = this.myVirtualFile.isWritable();
        }
        return this.myCachedWritable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/contentQueue/CachedFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/contentQueue/CachedFileContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytesOrEmpty";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

