/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.storage.sharding;

import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.storage.sharding.ShardableIndexExtension;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShardedForwardIndex
implements ForwardIndex {
    private final ShardableIndexExtension extension;
    private final ForwardIndex[] shards;
    private volatile boolean closed;

    <Value, Key> ShardedForwardIndex(@NotNull FileBasedIndexExtension<Key, Value> extension, @NotNull ThrowableNotNullFunction<Integer, ForwardIndex, IOException> forwardIndexesFactory) throws IOException {
        if (extension == null) {
            ShardedForwardIndex.$$$reportNull$$$0(0);
        }
        if (forwardIndexesFactory == null) {
            ShardedForwardIndex.$$$reportNull$$$0(1);
        }
        this.closed = false;
        if (!(extension instanceof ShardableIndexExtension)) {
            throw new IllegalArgumentException("Extension(" + String.valueOf(extension) + ") must be ShardableIndexExtension");
        }
        ShardableIndexExtension shardableExtension = (ShardableIndexExtension)extension;
        this.extension = shardableExtension;
        this.shards = new ForwardIndex[shardableExtension.shardsCount()];
        try {
            for (int shardNo = 0; shardNo < this.shards.length; ++shardNo) {
                this.shards[shardNo] = (ForwardIndex)forwardIndexesFactory.fun((Object)shardNo);
            }
        }
        catch (Throwable e) {
            try {
                IOUtil.closeAllSafely((Closeable[])this.shards);
            }
            catch (Throwable closeEx) {
                e.addSuppressed(closeEx);
            }
            throw e;
        }
    }

    @Nullable
    public ByteArraySequence get(@NotNull Integer inputId) throws IOException {
        if (inputId == null) {
            ShardedForwardIndex.$$$reportNull$$$0(2);
        }
        int shardNo = this.extension.shardNo(inputId);
        return this.shards[shardNo].get(inputId);
    }

    public void put(@NotNull Integer inputId, @Nullable ByteArraySequence value) throws IOException {
        if (inputId == null) {
            ShardedForwardIndex.$$$reportNull$$$0(3);
        }
        int shardNo = this.extension.shardNo(inputId);
        this.shards[shardNo].put(inputId, value);
    }

    public void clear() throws IOException {
        for (ForwardIndex shard : this.shards) {
            shard.clear();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        IOUtil.closeAllSafely((Closeable[])this.shards);
    }

    public void force() throws IOException {
        for (ForwardIndex shard : this.shards) {
            shard.force();
        }
    }

    public boolean isDirty() {
        for (ForwardIndex shard : this.shards) {
            if (!shard.isDirty()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndexesFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/storage/sharding/ShardedForwardIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

