/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.FileTypeIndexingHint;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PlainTextIdIndexer
implements IdIndexer,
FileTypeIndexingHint {
    private static final Key<Map<IdIndexEntry, Integer>> ID_INDEX_DATA_KEY = Key.create((String)"plain.text.id.index");

    @NotNull
    public ThreeState acceptsFileTypeFastPath(@NotNull FileType fileType) {
        if (fileType == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(0);
        }
        ThreeState threeState = ThreeState.fromBoolean((!FileBasedIndex.IGNORE_PLAIN_TEXT_FILES ? 1 : 0) != 0);
        if (threeState == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(1);
        }
        return threeState;
    }

    public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile file) {
        if (file == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(2);
        }
        throw new AssertionError((Object)"Should never come here");
    }

    @Override
    @NotNull
    public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(3);
        }
        return PlainTextIdIndexer.getIdIndexData(inputData);
    }

    @NotNull
    public static Map<IdIndexEntry, Integer> getIdIndexData(@NotNull FileContent content) {
        Map idIndexData;
        if (content == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(4);
        }
        if ((idIndexData = (Map)content.getUserData(ID_INDEX_DATA_KEY)) != null) {
            content.putUserData(ID_INDEX_DATA_KEY, null);
            Map map = idIndexData;
            if (map == null) {
                PlainTextIdIndexer.$$$reportNull$$$0(5);
            }
            return map;
        }
        final IdDataConsumer consumer = new IdDataConsumer();
        CharSequence text = content.getContentAsText();
        IdTableBuilding.scanWords(new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars11, char @Nullable [] charsArray, int start, int end) {
                if (charsArray != null) {
                    consumer.addOccurrence(charsArray, start, end, 16);
                } else {
                    consumer.addOccurrence(chars11, start, end, 16);
                }
            }
        }, text, 0, text.length());
        Map<IdIndexEntry, Integer> result = consumer.getResult();
        if (TodoIndexers.needsTodoIndex((IndexedFile)content) && !FileBasedIndex.IGNORE_PLAIN_TEXT_FILES) {
            content.putUserData(ID_INDEX_DATA_KEY, result);
        }
        Map<IdIndexEntry, Integer> map = result;
        if (map == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(6);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/PlainTextIdIndexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/PlainTextIdIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptsFileTypeFastPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdIndexData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFileTypeFastPath";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "slowPathIfFileTypeHintUnsure";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIdIndexData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6 -> new IllegalStateException(string);
        };
    }
}

