/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.OverrideOnly
public abstract class ScanningIdIndexer
implements IdIndexer {
    protected abstract WordsScanner createScanner();

    @Override
    @NotNull
    public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            ScanningIdIndexer.$$$reportNull$$$0(0);
        }
        CharSequence chars = inputData.getContentAsText();
        IdDataConsumer consumer = new IdDataConsumer();
        this.createScanner().processWords(chars, ScanningIdIndexer.createProcessor(chars, consumer));
        Map<IdIndexEntry, Integer> map = consumer.getResult();
        if (map == null) {
            ScanningIdIndexer.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    protected static Processor<WordOccurrence> createProcessor(final @NotNull CharSequence chars, final @NotNull IdDataConsumer consumer) {
        if (chars == null) {
            ScanningIdIndexer.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            ScanningIdIndexer.$$$reportNull$$$0(3);
        }
        final char[] charsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)chars);
        return new Processor<WordOccurrence>(){

            public boolean process(WordOccurrence t) {
                if (charsArray != null && t.getBaseText() == chars) {
                    consumer.addOccurrence(charsArray, t.getStart(), t.getEnd(), 1.convertToMask(t.getKind()));
                } else {
                    consumer.addOccurrence(t.getBaseText(), t.getStart(), t.getEnd(), 1.convertToMask(t.getKind()));
                }
                return true;
            }

            private static int convertToMask(WordOccurrence.Kind kind) {
                if (kind == null) {
                    return 255;
                }
                if (kind == WordOccurrence.Kind.CODE) {
                    return 1;
                }
                if (kind == WordOccurrence.Kind.COMMENTS) {
                    return 2;
                }
                if (kind == WordOccurrence.Kind.LITERALS) {
                    return 4;
                }
                if (kind == WordOccurrence.Kind.FOREIGN_LANGUAGE) {
                    return 8;
                }
                return 0;
            }
        };
    }

    @Override
    public int getVersion() {
        WordsScanner scanner = this.createScanner();
        return scanner instanceof VersionedWordsScanner ? ((VersionedWordsScanner)scanner).getVersion() : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/ScanningIdIndexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/ScanningIdIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

