/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class ByteArrayInterner {
    private static final Hash.Strategy<byte[]> BYTE_ARRAY_STRATEGY = new Hash.Strategy<byte[]>(){

        public int hashCode(byte[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(byte[] o1, byte[] o2) {
            return Arrays.equals(o1, o2);
        }
    };
    private final Object2IntMap<byte[]> arrayToStart = new Object2IntOpenCustomHashMap(BYTE_ARRAY_STRATEGY);
    final BufferExposingByteArrayOutputStream joinedBuffer = new BufferExposingByteArrayOutputStream();

    ByteArrayInterner() {
    }

    int internBytes(byte @NotNull [] bytes) {
        if (bytes == null) {
            ByteArrayInterner.$$$reportNull$$$0(0);
        }
        if (bytes.length == 0) {
            return 0;
        }
        int start = this.arrayToStart.getInt((Object)bytes);
        if (start == 0) {
            start = this.joinedBuffer.size() + 1;
            this.arrayToStart.put((Object)bytes, start);
            this.joinedBuffer.write(bytes, 0, bytes.length);
        }
        return start;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/psi/stubs/ByteArrayInterner", "internBytes"));
    }
}

