/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ByteArrayInterner;
import com.intellij.psi.stubs.EmptyStubSerializer;
import com.intellij.psi.stubs.FileLocalStringEnumerator;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.LazyStubList;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElementRegistryServiceImpl;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.stubs.StubStringInterner;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class StubTreeSerializerBase<SerializationState> {
    static final ThreadLocal<ObjectStubSerializer<?, ? extends Stub>> ourRootStubSerializer = new ThreadLocal();
    private static final boolean useStubStringInterner = Boolean.parseBoolean(System.getProperty("idea.use.stub.string.interner", "false"));
    @Nullable
    private final UnaryOperator<String> stubStringInterner = useStubStringInterner ? StubStringInterner.getInstance() : UnaryOperator.identity();

    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(0);
        }
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, (AbstractStringEnumerator)storage);
        @NotNull SerializationState state = this.readSerializationState(inputStream);
        if (this.stubStringInterner == null) {
            storage.read((DataInput)inputStream);
        } else {
            storage.read((DataInput)inputStream, this.stubStringInterner);
        }
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserializeRoot(inputStream, storage, state);
        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            PsiFileStub fileStub = (PsiFileStub)baseStub;
            stubs.add(fileStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize = this.deserializeRoot(inputStream, storage, state);
            if (deserialize instanceof PsiFileStub) {
                PsiFileStub fileStub = (PsiFileStub)deserialize;
                stubs.add(fileStub);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stub;
            fileStub.setStubRoots(stubsArray);
        }
        Stub stub = baseStub;
        if (stub == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(1);
        }
        return stub;
    }

    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(2);
        }
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(3);
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(true);
        @NotNull SerializationState serializationState = this.createSerializationState();
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStubImpl) {
            PsiFileStubImpl fileStub = (PsiFileStubImpl)rootStub;
            PsiFileStub[] roots = fileStub.getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + String.valueOf(rootStub));
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.serializeRoot(stubOutputStream, (Stub)root, storage, serializationState);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.serializeRoot(stubOutputStream, rootStub, storage, serializationState);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        this.saveSerializationState(serializationState, resultStream);
        storage.write(resultStream);
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    @NotNull
    protected abstract SerializationState readSerializationState(@NotNull StubInputStream var1) throws IOException;

    @NotNull
    protected abstract SerializationState createSerializationState();

    protected abstract void saveSerializationState(@NotNull SerializationState var1, @NotNull DataOutputStream var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stub deserializeRoot(StubInputStream inputStream, FileLocalStringEnumerator storage, @NotNull SerializationState state) throws IOException, SerializerNotFoundException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(4);
        }
        int serializedId = DataInputOutputUtil.readINT((DataInput)inputStream);
        ObjectStubSerializer<?, Stub> serializer2 = this.getClassByIdLocal(serializedId, null, state);
        ourRootStubSerializer.set(serializer2);
        try {
            Stub stub = serializer2.deserialize(inputStream, null);
            if (stub instanceof StubBase) {
                StubBase base = (StubBase)stub;
                this.deserializeStubList(base, serializer2, inputStream, storage, state);
            } else {
                this.deserializeChildren(inputStream, stub, state);
            }
            Stub stub2 = stub;
            return stub2;
        }
        finally {
            ourRootStubSerializer.remove();
        }
    }

    protected abstract int writeSerializerId(@NotNull ObjectStubSerializer<Stub, Stub> var1, @NotNull SerializationState var2) throws IOException;

    private void serializeSelf(Stub stub, @NotNull StubOutputStream stream, @NotNull SerializationState state) throws IOException {
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(5);
        }
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(6);
        }
        if (((ObjectStubBase)stub).isDangling()) {
            stream.writeByte(0);
        }
        this.writeSerializerId(stub, (DataOutput)stream, state).serialize(stub, stream);
    }

    @NotNull
    private ObjectStubSerializer<Stub, Stub> writeSerializerId(Stub stub, @NotNull DataOutput stream, @NotNull SerializationState state) throws IOException {
        ObjectStubSerializer serializer2;
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(7);
        }
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(8);
        }
        if ((serializer2 = StubSerializationUtil.getSerializer((Stub)stub)) == null) {
            throw new Error("No serializer was returned for " + String.valueOf(stub));
        }
        int localId = this.writeSerializerId((ObjectStubSerializer<Stub, Stub>)serializer2, state);
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)localId);
        ObjectStubSerializer objectStubSerializer = serializer2;
        if (objectStubSerializer == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(9);
        }
        return objectStubSerializer;
    }

    private void serializeChildren(@NotNull Stub parent, @NotNull StubOutputStream stream, @NotNull SerializationState state) throws IOException {
        if (parent == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(10);
        }
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(11);
        }
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(12);
        }
        List children = parent.getChildrenStubs();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)children.size());
        for (Stub child : children) {
            this.serializeSelf(child, stream, state);
            this.serializeChildren(child, stream, state);
        }
    }

    private void serializeRoot(StubOutputStream out, Stub root, AbstractStringEnumerator storage, @NotNull SerializationState state) throws IOException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(13);
        }
        this.serializeSelf(root, out, state);
        if (root instanceof StubBase) {
            StubBase base = (StubBase)root;
            StubList stubList = base.getStubList();
            if (root != stubList.get(0)) {
                throw new IllegalArgumentException("Serialization is supported only for root stubs");
            }
            this.serializeStubList(base, stubList, (DataOutput)out, storage, state);
        } else {
            this.serializeChildren(root, out, state);
        }
    }

    private void deserializeStubList(final StubBase<?> root, final ObjectStubSerializer<?, ? extends Stub> rootType, final StubInputStream inputStream, FileLocalStringEnumerator storage, final @NotNull SerializationState state) throws IOException, SerializerNotFoundException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(14);
        }
        int stubCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        final LazyStubList stubList = new LazyStubList(stubCount, root, rootType);
        final MostlyUShortIntList parentsAndStarts = new MostlyUShortIntList(stubCount * 2);
        final BitSet allStarts = new BitSet();
        new Object(){
            int currentIndex = 1;

            private void deserializeStub(int parentIndex) throws IOException, SerializerNotFoundException {
                int index = this.currentIndex++;
                int serializerId = DataInputOutputUtil.readINT((DataInput)inputStream);
                ObjectStubSerializer<?, Stub> serializer2 = StubTreeSerializerBase.this.getClassByIdLocal(serializerId, null, state);
                int start = serializer2 instanceof EmptyStubSerializer ? 0 : DataInputOutputUtil.readINT((DataInput)inputStream);
                allStarts.set(start);
                IElementType elementType = 1.serializer2type(serializer2);
                this.addStub(parentIndex, index, start, elementType);
                if (!serializer2.isAlwaysLeaf(root)) {
                    this.deserializeChildren(index);
                }
            }

            private void addStub(int parentIndex, int index, int start, IElementType type) {
                parentsAndStarts.add(parentIndex);
                parentsAndStarts.add(start);
                stubList.addLazyStub(type, index, parentIndex);
            }

            private void deserializeChildren(int parentIndex) throws IOException, SerializerNotFoundException {
                int childrenCount = DataInputOutputUtil.readINT((DataInput)inputStream);
                stubList.prepareForChildren(parentIndex, childrenCount);
                for (int i = 0; i < childrenCount; ++i) {
                    this.deserializeStub(parentIndex);
                }
            }

            void deserializeRoot() throws IOException, SerializerNotFoundException {
                this.addStub(0, 0, 0, 1.serializer2type(rootType));
                this.deserializeChildren(0);
            }

            @Nullable
            private static IElementType serializer2type(ObjectStubSerializer<?, ?> serializer2) {
                return StubElementRegistryServiceImpl.getInstanceImpl().getElementTypeBySerializer(serializer2);
            }
        }.deserializeRoot();
        byte[] serializedStubs = this.readByteArray(inputStream);
        stubList.setStubData(new LazyStubData(storage, parentsAndStarts, serializedStubs, allStarts));
    }

    private void serializeStubList(@NotNull StubBase<?> root, @NotNull StubList stubList, @NotNull DataOutput out, AbstractStringEnumerator storage, @NotNull SerializationState state) throws IOException {
        if (root == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(15);
        }
        if (stubList == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(16);
        }
        if (out == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(17);
        }
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(18);
        }
        if (!stubList.isChildrenLayoutOptimal()) {
            throw new IllegalArgumentException("Manually assembled stubs should be normalized before serialization, consider wrapping them into StubTree");
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.size());
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(0));
        BufferExposingByteArrayOutputStream tempBuffer = new BufferExposingByteArrayOutputStream();
        ByteArrayInterner interner = new ByteArrayInterner();
        for (int i = 1; i < stubList.size(); ++i) {
            StubBase stub = (StubBase)stubList.get(i);
            ObjectStubSerializer<Stub, Stub> serializer2 = this.writeSerializerId((Stub)stub, out, state);
            if (!(serializer2 instanceof EmptyStubSerializer)) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)interner.internBytes(StubTreeSerializerBase.serializeStub(serializer2, storage, stub, tempBuffer)));
            }
            int count = stubList.getChildrenCount(stub.id);
            if (!serializer2.isAlwaysLeaf(root)) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)count);
                continue;
            }
            if (count == 0) continue;
            throw new IllegalStateException("Serializer reported that children are not possible, but they are present. Serializer = " + serializer2.getClass().getName() + "; Children count = " + count);
        }
        StubTreeSerializerBase.writeByteArray(out, interner.joinedBuffer.getInternalBuffer(), interner.joinedBuffer.size());
    }

    private static byte[] serializeStub(ObjectStubSerializer<Stub, Stub> serializer2, AbstractStringEnumerator storage, StubBase<?> stub, BufferExposingByteArrayOutputStream tempBuffer) throws IOException {
        tempBuffer.reset();
        StubOutputStream stubOut = new StubOutputStream((OutputStream)tempBuffer, storage);
        serializer2.serialize(stub, stubOut);
        if (stub.isDangling()) {
            stubOut.writeByte(0);
        }
        return tempBuffer.size() == 0 ? ArrayUtilRt.EMPTY_BYTE_ARRAY : tempBuffer.toByteArray();
    }

    private byte[] readByteArray(StubInputStream inputStream) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (length == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] array = new byte[length];
        int read = inputStream.read(array);
        if (read != array.length) {
            Logger.getInstance(this.getClass()).error("Serialized array length mismatch");
        }
        return array;
    }

    private static void writeByteArray(DataOutput out, byte[] array, int len) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)len);
        out.write(array, 0, len);
    }

    protected abstract ObjectStubSerializer<?, Stub> getClassByIdLocal(int var1, @Nullable Stub var2, @NotNull SerializationState var3) throws SerializerNotFoundException;

    private void deserializeChildren(StubInputStream stream, Stub parent, @NotNull SerializationState state) throws IOException, SerializerNotFoundException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(19);
        }
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i = 0; i < childCount; ++i) {
            boolean dangling = false;
            int id = DataInputOutputUtil.readINT((DataInput)stream);
            if (id == 0) {
                dangling = true;
                id = DataInputOutputUtil.readINT((DataInput)stream);
            }
            Stub child = this.getClassByIdLocal(id, parent, state).deserialize(stream, parent);
            if (dangling) {
                ((ObjectStubBase)child).markDangling();
            }
            this.deserializeChildren(stream, child, state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTreeSerializerBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTreeSerializerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "writeSerializerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserializeRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeSelf";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeSerializerId";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serializeChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "serializeRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeStubList";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "serializeStubList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deserializeChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9 -> new IllegalStateException(string);
        };
    }
}

