/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexableSetContributorModificationTracker;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AdditionalIndexableFileSet
implements IndexableFileSet {
    @Nullable
    private final Project myProject;
    private final Supplier<List<IndexableSetContributor>> myExtensions;
    private final CachedValue<AdditionalIndexableRoots> myAdditionalIndexableRoots;

    public AdditionalIndexableFileSet(@Nullable Project project, @NotNull List<IndexableSetContributor> extensions) {
        if (extensions == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myExtensions = () -> extensions;
        this.myAdditionalIndexableRoots = new CachedValueImpl(() -> new CachedValueProvider.Result((Object)this.collectFilesAndDirectories(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    }

    public AdditionalIndexableFileSet(@Nullable Project project) {
        this.myProject = project;
        this.myExtensions = () -> IndexableSetContributor.EP_NAME.getExtensionList();
        this.myAdditionalIndexableRoots = new CachedValueImpl(() -> new CachedValueProvider.Result((Object)this.collectFilesAndDirectories(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, IndexableSetContributorModificationTracker.getInstance()}));
    }

    @NotNull
    private AdditionalIndexableRoots collectFilesAndDirectories() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        HashSet<VirtualFile> directories = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : this.myExtensions.get()) {
            for (VirtualFile root : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                if (root.isDirectory()) {
                    directories.add(root);
                    continue;
                }
                files.add(root);
            }
            if (this.myProject == null) continue;
            Set projectRoots = IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject);
            for (VirtualFile root : projectRoots) {
                if (root.isDirectory()) {
                    directories.add(root);
                    continue;
                }
                files.add(root);
            }
        }
        return new AdditionalIndexableRoots(files, directories);
    }

    @Override
    public boolean isInSet(@NotNull VirtualFile file) {
        if (file == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(1);
        }
        AdditionalIndexableRoots additionalIndexableRoots = (AdditionalIndexableRoots)this.myAdditionalIndexableRoots.getValue();
        return additionalIndexableRoots.files.contains(file) || VfsUtilCore.isUnderFiles((VirtualFile)file, additionalIndexableRoots.directories);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record AdditionalIndexableRoots(@NotNull Set<VirtualFile> files, @NotNull Set<VirtualFile> directories) {
        @NotNull
        private final Set<VirtualFile> files;
        @NotNull
        private final Set<VirtualFile> directories;

        private AdditionalIndexableRoots(@NotNull Set<VirtualFile> files, @NotNull Set<VirtualFile> directories) {
            if (files == null) {
                AdditionalIndexableRoots.$$$reportNull$$$0(0);
            }
            if (directories == null) {
                AdditionalIndexableRoots.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Set<VirtualFile> files() {
            Set<VirtualFile> set = this.files;
            if (set == null) {
                AdditionalIndexableRoots.$$$reportNull$$$0(2);
            }
            return set;
        }

        @NotNull
        public Set<VirtualFile> directories() {
            Set<VirtualFile> set = this.directories;
            if (set == null) {
                AdditionalIndexableRoots.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directories";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/AdditionalIndexableFileSet$AdditionalIndexableRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet$AdditionalIndexableRoots";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "files";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "directories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

