/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.forward.SingleEntryIndexForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayoutProviderKt;
import com.intellij.util.indexing.impl.storage.StorageFactories;
import com.intellij.util.indexing.impl.storage.StorageRef;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProvider;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.indexing.storage.sharding.ShardableIndexExtension;
import com.intellij.util.indexing.storage.sharding.ShardedStorageLayout;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayoutProvider;", "Lcom/intellij/util/indexing/storage/FileBasedIndexLayoutProvider;", "<init>", "()V", "getLayout", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "K", "V", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "otherApplicableProviders", "", "isApplicable", "", "isSupported", "toString", "", "DefaultStorageLayout", "SingleEntryStorageLayout", "intellij.platform.indexing.impl"})
@ApiStatus.Internal
@VisibleForTesting
public final class DefaultIndexStorageLayoutProvider
implements FileBasedIndexLayoutProvider {
    @Override
    @NotNull
    public <K, V> VfsAwareIndexStorageLayout<K, V> getLayout(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull Iterable<? extends FileBasedIndexLayoutProvider> otherApplicableProviders) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        Intrinsics.checkNotNullParameter(otherApplicableProviders, (String)"otherApplicableProviders");
        if (extension instanceof SingleEntryFileBasedIndexExtension) {
            return new SingleEntryStorageLayout((SingleEntryFileBasedIndexExtension)extension);
        }
        if (extension instanceof ShardableIndexExtension && ((ShardableIndexExtension)extension).shardsCount() > 1) {
            StorageFactories storageFactories = DefaultIndexStorageLayoutProviderKt.access$createDefaultFactories(extension);
            ThrowableNotNullFunction storageFactory2 = storageFactories.component1();
            ThrowableNotNullFunction<Integer, ForwardIndex, IOException> forwardFactory = storageFactories.component2();
            return new ShardedStorageLayout<K, V>(extension, forwardFactory, storageFactory2);
        }
        return new DefaultStorageLayout<K, V>(extension);
    }

    @Override
    public boolean isApplicable(@NotNull FileBasedIndexExtension<?, ?> extension) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        return true;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @NotNull
    public String toString() {
        String string = DefaultIndexStorageLayoutProvider.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\n\u001a\"\u0012\u000e\u0012\f\b\u0002 \f*\u0004\u0018\u00018\u00008\u0000\u0012\u000e\u0012\f\b\u0002 \f*\u0004\u0018\u00018\u00018\u00010\u000bX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayoutProvider$DefaultStorageLayout;", "K", "V", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "<init>", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;)V", "storageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "forwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/MapForwardIndexAccessor;", "kotlin.jvm.PlatformType", "forwardIndexRef", "Lcom/intellij/util/indexing/impl/storage/StorageRef;", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "Ljava/io/IOException;", "indexStorageRef", "Lcom/intellij/util/indexing/impl/IndexStorage;", "openIndexStorage", "openForwardIndex", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/ForwardIndexAccessor;", "clearIndexData", "", "intellij.platform.indexing.impl"})
    public static final class DefaultStorageLayout<K, V>
    implements VfsAwareIndexStorageLayout<K, V> {
        @NotNull
        private final FileBasedIndexExtension<K, V> extension;
        @NotNull
        private final StorageLockContext storageLockContext;
        @NotNull
        private final MapForwardIndexAccessor<K, V> forwardIndexAccessor;
        @NotNull
        private final StorageRef<ForwardIndex, IOException> forwardIndexRef;
        @NotNull
        private final StorageRef<IndexStorage<K, V>, IOException> indexStorageRef;

        public DefaultStorageLayout(@NotNull FileBasedIndexExtension<K, V> extension) {
            Intrinsics.checkNotNullParameter(extension, (String)"extension");
            this.extension = extension;
            this.storageLockContext = DefaultIndexStorageLayoutProviderKt.access$newStorageLockContext();
            this.forwardIndexAccessor = new MapForwardIndexAccessor(DefaultIndexStorageLayoutProviderKt.defaultMapExternalizerFor((IndexExtension)this.extension));
            this.forwardIndexRef = new StorageRef("ForwardIndex[" + this.extension.getName(), () -> DefaultStorageLayout.forwardIndexRef$lambda$0(this), ForwardIndex::isClosed, !VfsAwareIndexStorageLayout.WARN_IF_CLEANING_UNCLOSED_STORAGE);
            this.indexStorageRef = new StorageRef("IndexStorage[" + this.extension.getName() + "]", () -> DefaultStorageLayout.indexStorageRef$lambda$0(this), IndexStorage::isClosed, !VfsAwareIndexStorageLayout.WARN_IF_CLEANING_UNCLOSED_STORAGE);
        }

        @NotNull
        public synchronized IndexStorage<K, V> openIndexStorage() throws IOException {
            IndexStorage<K, V> indexStorage = this.indexStorageRef.reopen();
            Intrinsics.checkNotNullExpressionValue(indexStorage, (String)"reopen(...)");
            return indexStorage;
        }

        @NotNull
        public synchronized ForwardIndex openForwardIndex() throws IOException {
            ForwardIndex forwardIndex = this.forwardIndexRef.reopen();
            Intrinsics.checkNotNullExpressionValue((Object)forwardIndex, (String)"reopen(...)");
            return forwardIndex;
        }

        @NotNull
        public ForwardIndexAccessor<K, V> getForwardIndexAccessor() {
            return (ForwardIndexAccessor)this.forwardIndexAccessor;
        }

        @Override
        public synchronized void clearIndexData() {
            this.indexStorageRef.ensureClosed();
            this.forwardIndexRef.ensureClosed();
            DefaultIndexStorageLayoutProviderKt.access$getLOG$p().info("Clearing storage data for: " + this.extension);
            DefaultIndexStorageLayoutProviderKt.access$deleteIndexDirectory(this.extension);
        }

        private static final ForwardIndex forwardIndexRef$lambda$0(DefaultStorageLayout this$0) {
            Path path = IndexInfrastructure.getInputIndexStorageFile(this$0.extension.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getInputIndexStorageFile(...)");
            Path indexStorageFile = path;
            return (ForwardIndex)new PersistentMapBasedForwardIndex(indexStorageFile, false, false, this$0.storageLockContext);
        }

        private static final IndexStorage indexStorageRef$lambda$0(DefaultStorageLayout this$0) {
            return DefaultIndexStorageLayoutProviderKt.access$createIndexStorage(this$0.extension, this$0.storageLockContext);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00008\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayoutProvider$SingleEntryStorageLayout;", "V", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "", "extension", "Lcom/intellij/util/indexing/SingleEntryFileBasedIndexExtension;", "<init>", "(Lcom/intellij/util/indexing/SingleEntryFileBasedIndexExtension;)V", "storageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "forwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor;", "kotlin.jvm.PlatformType", "indexStorageRef", "Lcom/intellij/util/indexing/impl/storage/StorageRef;", "Lcom/intellij/util/indexing/impl/IndexStorage;", "Ljava/io/IOException;", "openIndexStorage", "openForwardIndex", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/ForwardIndexAccessor;", "clearIndexData", "", "intellij.platform.indexing.impl"})
    public static final class SingleEntryStorageLayout<V>
    implements VfsAwareIndexStorageLayout<Integer, V> {
        @NotNull
        private final SingleEntryFileBasedIndexExtension<V> extension;
        @NotNull
        private final StorageLockContext storageLockContext;
        @NotNull
        private final SingleEntryIndexForwardIndexAccessor<V> forwardIndexAccessor;
        @NotNull
        private final StorageRef<IndexStorage<Integer, V>, IOException> indexStorageRef;

        public SingleEntryStorageLayout(@NotNull SingleEntryFileBasedIndexExtension<V> extension) {
            Intrinsics.checkNotNullParameter(extension, (String)"extension");
            this.extension = extension;
            this.storageLockContext = DefaultIndexStorageLayoutProviderKt.access$newStorageLockContext();
            this.forwardIndexAccessor = new SingleEntryIndexForwardIndexAccessor<V>(this.extension);
            this.indexStorageRef = new StorageRef("IndexStorage[" + this.extension.getName() + "]", () -> SingleEntryStorageLayout.indexStorageRef$lambda$0(this), IndexStorage::isClosed, !VfsAwareIndexStorageLayout.WARN_IF_CLEANING_UNCLOSED_STORAGE);
        }

        @NotNull
        public synchronized IndexStorage<Integer, V> openIndexStorage() throws IOException {
            IndexStorage<Integer, V> indexStorage = this.indexStorageRef.reopen();
            Intrinsics.checkNotNullExpressionValue(indexStorage, (String)"reopen(...)");
            return indexStorage;
        }

        @NotNull
        public ForwardIndex openForwardIndex() {
            EmptyForwardIndex emptyForwardIndex = EmptyForwardIndex.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)emptyForwardIndex, (String)"INSTANCE");
            return (ForwardIndex)emptyForwardIndex;
        }

        @NotNull
        public ForwardIndexAccessor<Integer, V> getForwardIndexAccessor() {
            return (ForwardIndexAccessor)this.forwardIndexAccessor;
        }

        @Override
        public synchronized void clearIndexData() throws IOException {
            this.indexStorageRef.ensureClosed();
            DefaultIndexStorageLayoutProviderKt.access$getLOG$p().info("Clearing storage data for: " + this.extension);
            DefaultIndexStorageLayoutProviderKt.access$deleteIndexDirectory((FileBasedIndexExtension)this.extension);
        }

        private static final IndexStorage indexStorageRef$lambda$0(SingleEntryStorageLayout this$0) {
            return DefaultIndexStorageLayoutProviderKt.access$createIndexStorage((FileBasedIndexExtension)this$0.extension, this$0.storageLockContext);
        }
    }
}

