/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.SystemProperties;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class StorageRef<C extends Closeable, E extends Exception> {
    private static final Logger LOG = Logger.getInstance(StorageRef.class);
    private static final boolean CLOSE_BEFORE_REOPEN = SystemProperties.getBooleanProperty((String)"indexes.force-close-before-reopen", (boolean)true);
    @Nullable
    private C storage;
    private final String storageName;
    @NotNull
    private final ThrowableComputable<? extends C, ? extends E> storageOpener;
    private final Predicate<C> isClosedPredicate;
    private final boolean failIfNotClosed;

    public StorageRef(@NotNull String storageName, @NotNull ThrowableComputable<? extends C, ? extends E> storageOpener, @NotNull @NotNull Predicate<@NotNull C> isClosedPredicate, boolean failIfNotClosed) {
        if (storageName == null) {
            StorageRef.$$$reportNull$$$0(0);
        }
        if (storageOpener == null) {
            StorageRef.$$$reportNull$$$0(1);
        }
        if (isClosedPredicate == null) {
            StorageRef.$$$reportNull$$$0(2);
        }
        this.storage = null;
        this.storageName = storageName;
        this.storageOpener = storageOpener;
        this.isClosedPredicate = isClosedPredicate;
        this.failIfNotClosed = failIfNotClosed;
    }

    public synchronized C reopen() throws E, IOException, IllegalStateException {
        if (this.storage == null || this.isClosedPredicate.test(this.storage)) {
            this.storage = (Closeable)this.storageOpener.compute();
            return this.storage;
        }
        String message = this.storageName + " is already created and !closed yet -- close the existing storage before re-opening it again";
        if (this.failIfNotClosed) {
            throw new IllegalStateException(message);
        }
        LOG.warn(message);
        if (CLOSE_BEFORE_REOPEN) {
            this.storage.close();
        }
        this.storage = (Closeable)this.storageOpener.compute();
        return this.storage;
    }

    public synchronized void ensureClosed() throws IOException, IllegalStateException {
        if (this.storage == null || this.isClosedPredicate.test(this.storage)) {
            return;
        }
        String message = "Storage " + this.storageName + " is not closed yet";
        if (this.failIfNotClosed) {
            throw new IllegalStateException(message);
        }
        LOG.warn(message);
        if (CLOSE_BEFORE_REOPEN) {
            this.storage.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "storageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "storageOpener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "isClosedPredicate";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/indexing/impl/storage/StorageRef";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

