/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.ngrams;

import com.intellij.find.TextSearchService;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.find.ngrams.TrigramIndexFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TrigramTextSearchService
implements TextSearchService {
    private static final boolean USE_INDEX_FOR_SEARCH = SystemProperties.getBooleanProperty((String)"find.use.indexing.searcher.extensions", (boolean)true);
    private final TrigramIndexFilter trigramIndexFilter = (TrigramIndexFilter)ApplicationManager.getApplication().getService(TrigramIndexFilter.class);

    @NotNull
    public TextSearchService.TextSearchResult processFilesWithText(@NotNull String text, @NotNull Processor<? super VirtualFile> processor, @NotNull GlobalSearchScope scope) {
        IntSet keys;
        if (text == null) {
            TrigramTextSearchService.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            TrigramTextSearchService.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            TrigramTextSearchService.$$$reportNull$$$0(2);
        }
        if ((keys = TrigramBuilder.getTrigrams((CharSequence)text)).isEmpty()) {
            TextSearchService.TextSearchResult textSearchResult = TextSearchService.TextSearchResult.NO_TRIGRAMS;
            if (textSearchResult == null) {
                TrigramTextSearchService.$$$reportNull$$$0(3);
            }
            return textSearchResult;
        }
        boolean fullyCompleted = FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, (Set)keys, file -> {
            ProgressManager.checkCanceled();
            return processor.process(file);
        }, scope);
        TextSearchService.TextSearchResult textSearchResult = fullyCompleted ? TextSearchService.TextSearchResult.FINISHED : TextSearchService.TextSearchResult.STOPPED;
        if (textSearchResult == null) {
            TrigramTextSearchService.$$$reportNull$$$0(4);
        }
        return textSearchResult;
    }

    public boolean isInSearchableScope(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            TrigramTextSearchService.$$$reportNull$$$0(5);
        }
        if (project == null) {
            TrigramTextSearchService.$$$reportNull$$$0(6);
        }
        FileType fileType = file.getFileType();
        return !file.isDirectory() && this.isIndexable(file, project) && !ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file, (FileType)fileType) && !SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file);
    }

    public static boolean useIndexingSearchExtensions() {
        return USE_INDEX_FOR_SEARCH;
    }

    private boolean isIndexable(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            TrigramTextSearchService.$$$reportNull$$$0(7);
        }
        if (project == null) {
            TrigramTextSearchService.$$$reportNull$$$0(8);
        }
        IndexedFileImpl indexedFile = new IndexedFileImpl(file, project);
        return this.trigramIndexFilter.acceptInput((IndexedFile)indexedFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/ngrams/TrigramTextSearchService";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/ngrams/TrigramTextSearchService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processFilesWithText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithText";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInSearchableScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIndexable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

