/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.hints;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.hints.FileTypeIndexingHint;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/hints/BaseFileTypeInputFilter;", "Lcom/intellij/util/indexing/FileBasedIndex$ProjectSpecificInputFilter;", "Lcom/intellij/util/indexing/hints/FileTypeIndexingHint;", "fileTypeStrategy", "Lcom/intellij/util/indexing/hints/FileTypeSubstitutionStrategy;", "<init>", "(Lcom/intellij/util/indexing/hints/FileTypeSubstitutionStrategy;)V", "acceptsFileTypeFastPath", "Lcom/intellij/util/ThreeState;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "acceptInput", "", "file", "Lcom/intellij/util/indexing/IndexedFile;", "acceptFileType", "intellij.platform.indexing.impl"})
@ApiStatus.Experimental
@ApiStatus.OverrideOnly
public abstract class BaseFileTypeInputFilter
implements FileBasedIndex.ProjectSpecificInputFilter,
FileTypeIndexingHint {
    @NotNull
    private final FileTypeSubstitutionStrategy fileTypeStrategy;

    public BaseFileTypeInputFilter(@NotNull FileTypeSubstitutionStrategy fileTypeStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)fileTypeStrategy), (String)"fileTypeStrategy");
        this.fileTypeStrategy = fileTypeStrategy;
    }

    @NotNull
    public final ThreeState acceptsFileTypeFastPath(@NotNull FileType fileType) {
        FileType fileType2;
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        if (fileType instanceof SubstitutedFileType) {
            if (this.fileTypeStrategy == FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION) {
                FileType fileType3 = ((SubstitutedFileType)fileType).getOriginalFileType();
                fileType2 = fileType3;
                Intrinsics.checkNotNullExpressionValue((Object)fileType3, (String)"getOriginalFileType(...)");
            } else {
                FileType fileType4 = ((SubstitutedFileType)fileType).getFileType();
                fileType2 = fileType4;
                Intrinsics.checkNotNullExpressionValue((Object)fileType4, (String)"getFileType(...)");
            }
        } else {
            fileType2 = fileType;
        }
        FileType fileTypeToUse = fileType2;
        return this.acceptFileType(fileTypeToUse);
    }

    public final boolean acceptInput(@NotNull IndexedFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getFile().isDirectory()) {
            return false;
        }
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.acceptsFileTypeFastPath(fileType).ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case 3 -> this.slowPathIfFileTypeHintUnsure(file);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public abstract ThreeState acceptFileType(@NotNull FileType var1);

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

