/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.CustomInputMapIndexExtension;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.ValueLessInputMapExternalizer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayoutProvider;
import com.intellij.util.indexing.impl.storage.StorageFactories;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.storage.sharding.ShardableIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0007H\u0002\u001a>\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\n0\t\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0005\u0012\u0002\b\u00030\u000bH\u0007\u001a\u0018\u0010\f\u001a\u00020\r2\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0002\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0002\u001a<\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0011\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createDefaultFactories", "Lcom/intellij/util/indexing/impl/storage/StorageFactories;", "K", "V", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "defaultMapExternalizerFor", "Lcom/intellij/util/io/DataExternalizer;", "", "Lcom/intellij/util/indexing/IndexExtension;", "deleteIndexDirectory", "", "newStorageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "createIndexStorage", "Lcom/intellij/util/indexing/VfsAwareIndexStorage;", "storageLockContext", "intellij.platform.indexing.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultIndexStorageLayoutProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultIndexStorageLayoutProvider.kt\ncom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayoutProviderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,237:1\n13#2:238\n*S KotlinDebug\n*F\n+ 1 DefaultIndexStorageLayoutProvider.kt\ncom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayoutProviderKt\n*L\n22#1:238\n*E\n"})
public final class DefaultIndexStorageLayoutProviderKt {
    @NotNull
    private static final Logger LOG;

    private static final <K, V> StorageFactories<K, V> createDefaultFactories(FileBasedIndexExtension<K, V> extension) {
        Intrinsics.checkNotNull(extension, (String)"null cannot be cast to non-null type com.intellij.util.indexing.storage.sharding.ShardableIndexExtension");
        int shardsCount = ((ShardableIndexExtension)extension).shardsCount();
        int n = 0;
        StorageLockContext[] storageLockContextArray = new StorageLockContext[shardsCount];
        while (n < shardsCount) {
            int n2 = n++;
            storageLockContextArray[n2] = DefaultIndexStorageLayoutProviderKt.newStorageLockContext();
        }
        StorageLockContext[] storageLockContexts = storageLockContextArray;
        ThrowableNotNullFunction storageFactory2 = arg_0 -> DefaultIndexStorageLayoutProviderKt.createDefaultFactories$lambda$0(extension, storageLockContexts, arg_0);
        ThrowableNotNullFunction forwardFactory = arg_0 -> DefaultIndexStorageLayoutProviderKt.createDefaultFactories$lambda$1(extension, storageLockContexts, arg_0);
        return new StorageFactories(storageFactory2, (ThrowableNotNullFunction<Integer, ForwardIndex, IOException>)forwardFactory);
    }

    @ApiStatus.Internal
    @NotNull
    public static final <K, V> DataExternalizer<Map<K, V>> defaultMapExternalizerFor(@NotNull IndexExtension<K, V, ?> extension) {
        DataExternalizer keysExternalizer;
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        if (extension instanceof CustomInputMapIndexExtension) {
            DataExternalizer dataExternalizer = ((CustomInputMapIndexExtension)extension).createInputMapExternalizer();
            Intrinsics.checkNotNullExpressionValue(dataExternalizer, (String)"createInputMapExternalizer(...)");
            return dataExternalizer;
        }
        if (extension instanceof CustomInputsIndexFileBasedIndexExtension) {
            DataExternalizer dataExternalizer = ((CustomInputsIndexFileBasedIndexExtension)extension).createExternalizer();
            Intrinsics.checkNotNull((Object)dataExternalizer);
            v1 = dataExternalizer;
        } else {
            v1 = keysExternalizer = (DataExternalizer)new InputIndexDataExternalizer(extension.getKeyDescriptor(), extension.getName());
        }
        if (extension instanceof ScalarIndexExtension) {
            ValueLessInputMapExternalizer inputMapExternalizer = new ValueLessInputMapExternalizer(keysExternalizer);
            return inputMapExternalizer;
        }
        return new InputMapExternalizer(keysExternalizer, extension.getValueExternalizer(), false);
    }

    private static final void deleteIndexDirectory(FileBasedIndexExtension<?, ?> extension) {
        FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(extension.getName()).toFile());
    }

    private static final StorageLockContext newStorageLockContext() {
        return new StorageLockContext(false, true);
    }

    private static final <K, V> VfsAwareIndexStorage<K, V> createIndexStorage(FileBasedIndexExtension<K, V> extension, StorageLockContext storageLockContext) throws IOException {
        Path path = IndexInfrastructure.getStorageFile(extension.getName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getStorageFile(...)");
        Path storageFile = path;
        KeyDescriptor keyDescriptor = extension.getKeyDescriptor();
        DataExternalizer dataExternalizer = extension.getValueExternalizer();
        int n = extension.getCacheSize();
        boolean bl = extension.keyIsUniqueForIndexedFile();
        boolean bl2 = extension.traceKeyHashToVirtualFileMapping();
        boolean bl3 = extension.enableWal();
        return new VfsAwareMapIndexStorage<K, V>(storageFile, storageLockContext, keyDescriptor, dataExternalizer, n, bl, bl2, bl3){
            final /* synthetic */ StorageLockContext $storageLockContext;
            {
                this.$storageLockContext = $storageLockContext;
                super($storageFile, $super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initMapAndCache() {
                boolean bl;
                boolean bl2 = bl = PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get() == null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(this.$storageLockContext);
                try {
                    super.initMapAndCache();
                }
                finally {
                    PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
                }
            }
        };
    }

    private static final VfsAwareIndexStorage createDefaultFactories$lambda$0(FileBasedIndexExtension $extension, StorageLockContext[] $storageLockContexts, Integer shardNo) {
        Intrinsics.checkNotNullParameter((Object)shardNo, (String)"shardNo");
        Path path = IndexInfrastructure.getStorageFile($extension.getName(), shardNo);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getStorageFile(...)");
        Path shardStorageFile = path;
        StorageLockContext storageLockContext = $storageLockContexts[shardNo];
        KeyDescriptor keyDescriptor = $extension.getKeyDescriptor();
        DataExternalizer dataExternalizer = $extension.getValueExternalizer();
        int n = $extension.getCacheSize();
        boolean bl = $extension.keyIsUniqueForIndexedFile();
        boolean bl2 = $extension.traceKeyHashToVirtualFileMapping();
        boolean bl3 = $extension.enableWal();
        return new VfsAwareMapIndexStorage<K, V>(shardStorageFile, storageLockContext, keyDescriptor, dataExternalizer, n, bl, bl2, bl3){
            final /* synthetic */ StorageLockContext $storageLockContext;
            {
                this.$storageLockContext = $storageLockContext;
                super($shardStorageFile, $super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initMapAndCache() {
                PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(this.$storageLockContext);
                try {
                    super.initMapAndCache();
                }
                finally {
                    PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
                }
            }
        };
    }

    private static final ForwardIndex createDefaultFactories$lambda$1(FileBasedIndexExtension $extension, StorageLockContext[] $storageLockContexts, Integer shardNo) {
        Intrinsics.checkNotNullParameter((Object)shardNo, (String)"shardNo");
        Path path = IndexInfrastructure.getInputIndexStorageFile($extension.getName(), shardNo);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getInputIndexStorageFile(...)");
        Path shardStorageFile = path;
        return (ForwardIndex)new PersistentMapBasedForwardIndex(shardStorageFile, false, false, $storageLockContexts[shardNo]);
    }

    public static final /* synthetic */ StorageFactories access$createDefaultFactories(FileBasedIndexExtension extension) {
        return DefaultIndexStorageLayoutProviderKt.createDefaultFactories(extension);
    }

    public static final /* synthetic */ StorageLockContext access$newStorageLockContext() {
        return DefaultIndexStorageLayoutProviderKt.newStorageLockContext();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$deleteIndexDirectory(FileBasedIndexExtension extension) {
        DefaultIndexStorageLayoutProviderKt.deleteIndexDirectory(extension);
    }

    public static final /* synthetic */ VfsAwareIndexStorage access$createIndexStorage(FileBasedIndexExtension extension, StorageLockContext storageLockContext) {
        return DefaultIndexStorageLayoutProviderKt.createIndexStorage(extension, storageLockContext);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DefaultIndexStorageLayoutProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

