/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.text.StringSearcher;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LowLevelSearchUtil {
    private static final Logger LOG = Logger.getInstance(LowLevelSearchUtil.class);
    private static final ConcurrentMap<CharSequence, Map<StringSearcher, int[]>> cache = CollectionFactory.createConcurrentWeakIdentityMap();

    private LowLevelSearchUtil() {
    }

    private static Boolean processInjectedFile(PsiElement element, @NotNull StringSearcher searcher, int start, @NotNull ProgressIndicator progress, InjectedLanguageManager injectedLanguageManager, @NotNull TextOccurenceProcessor processor) {
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(0);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        if (injectedLanguageManager == null) {
            return null;
        }
        List list = injectedLanguageManager.getInjectedPsiFiles(element);
        if (list == null) {
            return null;
        }
        boolean hasMatchedRange = false;
        for (Pair pair : list) {
            if (!((TextRange)pair.second).containsRange(start, start + searcher.getPatternLength())) continue;
            hasMatchedRange = true;
            PsiElement injected = (PsiElement)pair.getFirst();
            if (LowLevelSearchUtil.processElementsContainingWordInElement(processor, injected, searcher, false, progress)) continue;
            return Boolean.FALSE;
        }
        return hasMatchedRange ? Boolean.TRUE : null;
    }

    private static boolean processTreeUp(@NotNull Project project, @NotNull PsiElement scope, @NotNull ASTNode leafNode, int offsetInLeaf, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress, @NotNull TextOccurenceProcessor processor) {
        if (project == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(4);
        }
        if (leafNode == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(5);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(8);
        }
        int patternLength = searcher.getPatternLength();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        ASTNode currentNode = leafNode;
        int currentOffset = offsetInLeaf;
        boolean contains = false;
        ASTNode prevNode = null;
        PsiElement run = null;
        while (run != scope) {
            ProgressManager.checkCanceled();
            currentOffset += prevNode == null ? 0 : prevNode.getStartOffsetInParent();
            prevNode = currentNode;
            run = currentNode.getPsi();
            if (!contains) {
                boolean bl = contains = run.getTextLength() - currentOffset >= patternLength;
            }
            if (contains) {
                Boolean result;
                if (processInjectedPsi && (result = LowLevelSearchUtil.processInjectedFile(run, searcher, currentOffset, progress, injectedLanguageManager, processor)) != null) {
                    return result;
                }
                if (!processor.execute(run, currentOffset)) {
                    return false;
                }
            }
            if ((currentNode = currentNode.getTreeParent()) != null) continue;
        }
        assert (run == scope) : "Malbuilt PSI; scopeNode: " + String.valueOf(scope) + "; containingFile: " + String.valueOf(PsiTreeUtil.getParentOfType((PsiElement)scope, PsiFile.class, (boolean)false)) + "; currentNode: " + String.valueOf(run) + "; isAncestor: " + PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)run, (boolean)false) + "; in same file: " + (PsiTreeUtil.getParentOfType((PsiElement)scope, PsiFile.class, (boolean)false) == PsiTreeUtil.getParentOfType((PsiElement)run, PsiFile.class, (boolean)false));
        return true;
    }

    private static ASTNode findNextLeafElementAt(@NotNull ASTNode scopeNode, @Nullable ASTNode last, int offset) {
        if (scopeNode == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(9);
        }
        int offsetR = offset;
        if (last != null) {
            offsetR -= last.getStartOffset() - scopeNode.getStartOffset() + last.getTextLength();
            while (offsetR >= 0) {
                ASTNode next = last.getTreeNext();
                if (next == null) {
                    last = last.getTreeParent();
                    continue;
                }
                int length = next.getTextLength();
                offsetR -= length;
                last = next;
            }
            scopeNode = last;
            offsetR += scopeNode.getTextLength();
        }
        return scopeNode.findLeafElementAt(offsetR);
    }

    public static boolean processElementsContainingWordInElement(@NotNull TextOccurenceProcessor processor, @NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress) {
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(11);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(12);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(13);
        }
        int[] occurrences = LowLevelSearchUtil.getTextOccurrencesInScope(scope, searcher);
        return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, processInjectedPsi, progress, occurrences, processor);
    }

    static int @NotNull [] getTextOccurrencesInScope(@NotNull PsiElement scope, @NotNull StringSearcher searcher) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(14);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        PsiFile file = scope.getContainingFile();
        FileViewProvider viewProvider = file.getViewProvider();
        CharSequence buffer = viewProvider.getContents();
        TextRange range = scope.getTextRange();
        if (range == null) {
            LOG.error("Element " + String.valueOf(scope) + " of class " + String.valueOf(scope.getClass()) + " has null range");
            if (ArrayUtilRt.EMPTY_INT_ARRAY == null) {
                LowLevelSearchUtil.$$$reportNull$$$0(16);
            }
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        if (endOffset > buffer.length()) {
            LowLevelSearchUtil.diagnoseInvalidRange(scope, file, viewProvider, buffer, range);
            if (ArrayUtilRt.EMPTY_INT_ARRAY == null) {
                LowLevelSearchUtil.$$$reportNull$$$0(17);
            }
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int[] offsets = LowLevelSearchUtil.getTextOccurrences(buffer, startOffset, endOffset, searcher);
        int i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - startOffset;
        }
        if (offsets == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(18);
        }
        return offsets;
    }

    static boolean processElementsAtOffsets(@NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress, int @NotNull [] offsetsInScope, @NotNull TextOccurenceProcessor processor) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(19);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(20);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(22);
        }
        if (offsetsInScope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(23);
        }
        if (offsetsInScope.length == 0) {
            return true;
        }
        ASTNode scopeNode = scope.getNode();
        if (scopeNode == null) {
            throw new IllegalArgumentException("Scope doesn't have node, can't scan: " + String.valueOf(scope) + "; containingFile: " + String.valueOf(scope.getContainingFile()));
        }
        Project project = scope.getProject();
        return LowLevelSearchUtil.processOffsets(scopeNode, offsetsInScope, progress, (node, offsetInNode) -> LowLevelSearchUtil.processTreeUp(project, scope, node, offsetInNode, searcher, processInjectedPsi, progress, processor));
    }

    static boolean processOffsets(@NotNull ASTNode node, int @NotNull [] offsetsInNode, @NotNull ProgressIndicator progress, @NotNull NodeTextOccurrenceProcessor processor) {
        if (node == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(24);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(26);
        }
        if (offsetsInNode == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(27);
        }
        int scopeStartOffset = node.getStartOffset();
        ASTNode lastElement = null;
        for (int offset : offsetsInNode) {
            progress.checkCanceled();
            ASTNode leafNode = LowLevelSearchUtil.findNextLeafElementAt(node, lastElement, offset);
            if (leafNode == null) {
                PsiElement psi = node.getPsi();
                LOG.error("Cannot find leaf: node=" + String.valueOf(node) + "; psi= " + String.valueOf(psi) + "; language=" + String.valueOf(psi == null ? null : psi.getLanguage()) + "; offset=" + offset + "; lastElement=" + String.valueOf(lastElement));
                continue;
            }
            int offsetInLeaf = offset - leafNode.getStartOffset() + scopeStartOffset;
            if (offsetInLeaf < 0) {
                throw new AssertionError((Object)("offset=" + offset + "; scopeStartOffset=" + scopeStartOffset + "; node=" + String.valueOf(node)));
            }
            if (!processor.execute(leafNode, offsetInLeaf)) {
                return false;
            }
            lastElement = leafNode;
        }
        return true;
    }

    private static void diagnoseInvalidRange(@NotNull PsiElement scope, @NotNull PsiFile file, @NotNull FileViewProvider viewProvider, @NotNull CharSequence buffer, TextRange range) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(28);
        }
        if (file == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(29);
        }
        if (viewProvider == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(30);
        }
        if (buffer == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(31);
        }
        String msg = "Range for element: '" + String.valueOf(scope) + "' = " + String.valueOf(range) + " is out of file '" + String.valueOf(file) + "' range: " + String.valueOf(file.getTextRange());
        msg = msg + "; file contents length: " + buffer.length();
        msg = msg + "\n file provider: " + String.valueOf(viewProvider);
        Document document = viewProvider.getDocument();
        if (document != null) {
            msg = msg + "\n committed=" + PsiDocumentManager.getInstance((Project)file.getProject()).isCommitted(document);
        }
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            msg = msg + "\n root " + String.valueOf(language) + " length=" + root.getTextLength() + (String)(root instanceof PsiFileImpl ? "; contentsLoaded=" + ((PsiFileImpl)root).isContentsLoaded() : "");
        }
        LOG.error(msg);
    }

    public static boolean processTexts(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @NotNull IntPredicate processor) {
        if (text == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(32);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(34);
        }
        for (int offset : LowLevelSearchUtil.getTextOccurrences(text, startOffset, endOffset, searcher)) {
            if (processor.test(offset)) continue;
            return false;
        }
        return true;
    }

    private static int @NotNull [] getTextOccurrences(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher) {
        int occurrence;
        boolean hasCachedOccurrences;
        if (text == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(35);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(36);
        }
        if (endOffset > text.length()) {
            throw new IllegalArgumentException("end: " + endOffset + " > length: " + text.length());
        }
        Map cachedMap = (Map)cache.get(text);
        int[] cachedOccurrences = cachedMap == null ? null : (int[])cachedMap.get(searcher);
        boolean bl = hasCachedOccurrences = cachedOccurrences != null && cachedOccurrences[0] <= startOffset && cachedOccurrences[1] >= endOffset;
        if (!hasCachedOccurrences) {
            IntArrayList occurrences = new IntArrayList();
            int newStart = Math.min(startOffset, cachedOccurrences == null ? startOffset : cachedOccurrences[0]);
            int newEnd = Math.max(endOffset, cachedOccurrences == null ? endOffset : cachedOccurrences[1]);
            occurrences.add(newStart);
            occurrences.add(newEnd);
            for (int index = newStart; index < newEnd; ++index) {
                ProgressManager.checkCanceled();
                index = searcher.scan(text, index, newEnd);
                if (index < 0) break;
                if (!LowLevelSearchUtil.checkJavaIdentifier(text, searcher, index)) continue;
                occurrences.add(index);
            }
            cachedOccurrences = occurrences.toIntArray();
            if (cachedMap == null) {
                cachedMap = (Map)ConcurrencyUtil.cacheOrGet(cache, (Object)text, (Object)CollectionFactory.createConcurrentSoftMap());
            }
            cachedMap.put(searcher, cachedOccurrences);
        }
        IntArrayList offsets = new IntArrayList(cachedOccurrences.length - 2);
        for (int i = 2; i < cachedOccurrences.length && (occurrence = cachedOccurrences[i]) <= endOffset - searcher.getPatternLength(); ++i) {
            if (occurrence < startOffset) continue;
            offsets.add(occurrence);
        }
        int[] nArray = offsets.toIntArray();
        if (nArray == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(37);
        }
        return nArray;
    }

    private static boolean checkJavaIdentifier(@NotNull CharSequence text, @NotNull StringSearcher searcher, int index) {
        char c;
        if (text == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(38);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(39);
        }
        if (!searcher.isJavaIdentifier()) {
            return true;
        }
        if (index > 0 && (Character.isJavaIdentifierPart(c = text.charAt(index - 1)) && c != '$' ? !searcher.isHandleEscapeSequences() || index < 2 || StringUtil.isEscapedBackslash((CharSequence)text, (int)0, (int)(index - 2)) : searcher.isHandleEscapeSequences() && !StringUtil.isEscapedBackslash((CharSequence)text, (int)0, (int)(index - 1)))) {
            return false;
        }
        int patternLength = searcher.getPattern().length();
        if (index + patternLength < text.length()) {
            char c2 = text.charAt(index + patternLength);
            return !Character.isJavaIdentifierPart(c2) || c2 == '$';
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17, 18, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 1: 
            case 7: 
            case 13: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 22: 
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeNode";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/LowLevelSearchUtil";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetsInScope";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetsInNode";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/LowLevelSearchUtil";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextOccurrencesInScope";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTreeUp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findNextLeafElementAt";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processElementsContainingWordInElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrencesInScope";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 37: {
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processElementsAtOffsets";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processOffsets";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "diagnoseInvalidRange";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processTexts";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrences";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkJavaIdentifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 17, 18, 37 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    static interface NodeTextOccurrenceProcessor {
        public boolean execute(@NotNull ASTNode var1, int var2);
    }
}

