/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.memory;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorageLockingBase;
import com.intellij.util.indexing.impl.IndexStorageUtil;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.ValueContainerProcessor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InMemoryIndexStorage<K, V>
extends IndexStorageLockingBase
implements VfsAwareIndexStorage<K, V> {
    private final Map<K, ValueContainerImpl<V>> inMemoryStorage;
    private volatile boolean closed;

    public InMemoryIndexStorage(@NotNull KeyDescriptor<K> keyDescriptor) {
        if (keyDescriptor == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(0);
        }
        this.closed = false;
        this.inMemoryStorage = ConcurrentCollectionFactory.createConcurrentMap((HashingStrategy)IndexStorageUtil.adaptKeyDescriptorToStrategy(keyDescriptor));
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (processor == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(2);
        }
        return (Boolean)this.withReadLock(() -> ContainerUtil.and(this.inMemoryStorage.keySet(), arg_0 -> ((Processor)processor).process(arg_0)));
    }

    public void addValue(K k, int inputId, V v) {
        this.withWriteLock(() -> this.inMemoryStorage.computeIfAbsent(k, __ -> ValueContainerImpl.createNewValueContainer()).addValue(inputId, v));
    }

    public void removeAllValues(@NotNull K k, int inputId) {
        if (k == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(3);
        }
        this.withWriteLock(() -> {
            ValueContainerImpl<V> container = this.inMemoryStorage.get(k);
            if (container == null) {
                return;
            }
            container.removeAssociatedValue(inputId);
            if (container.size() == 0) {
                this.inMemoryStorage.remove(k);
            }
        });
    }

    public void updateValue(K key, int inputId, V newValue) throws StorageException {
        this.withWriteLock(() -> {
            this.removeAllValues(key, inputId);
            this.addValue(key, inputId, newValue);
        });
    }

    public void clear() {
        this.inMemoryStorage.clear();
    }

    public <E extends Exception> boolean read(K key, @NotNull ValueContainerProcessor<V, E> processor) throws StorageException, E {
        if (processor == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(4);
        }
        try (IndexStorageLockingBase.LockStamp ignored = this.lockForRead();){
            ValueContainerImpl<V> container = this.inMemoryStorage.get(key);
            boolean bl = processor.process(Objects.requireNonNullElse(container, ValueContainer.emptyContainer()));
            return bl;
        }
    }

    public void clearCaches() {
    }

    public void close() {
        this.closed = true;
    }

    @ApiStatus.Internal
    public boolean isClosed() {
        return this.closed;
    }

    public void flush() {
    }

    public boolean isDirty() {
        return false;
    }

    public int keysCountApproximately() {
        return this.inMemoryStorage.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/memory/InMemoryIndexStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeys";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAllValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

