/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class MapReduceIndexBase<Key, Value, FileCache>
extends MapReduceIndex<Key, Value, FileContent>
implements UpdatableIndex<Key, Value, FileContent, FileCache> {
    private final boolean mySingleEntryIndex;

    protected MapReduceIndexBase(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull ThrowableComputable<? extends IndexStorage<Key, Value>, ? extends IOException> storageFactory2, @Nullable ThrowableComputable<? extends ForwardIndex, ? extends IOException> forwardIndexFactory, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) throws IOException {
        if (extension == null) {
            MapReduceIndexBase.$$$reportNull$$$0(0);
        }
        if (storageFactory2 == null) {
            MapReduceIndexBase.$$$reportNull$$$0(1);
        }
        super(extension, storageFactory2, forwardIndexFactory, forwardIndexAccessor);
        IndexId indexId = super.indexId();
        if (!(indexId instanceof ID)) {
            throw new IllegalArgumentException("extension.getName() (=" + String.valueOf(indexId) + ") should be instance of com.intellij.util.indexing.ID");
        }
        this.mySingleEntryIndex = extension instanceof SingleEntryFileBasedIndexExtension;
    }

    public ID<Key, Value> indexId() {
        return (ID)super.indexId();
    }

    @Override
    public boolean processAllKeys(@NotNull Processor<? super Key> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            MapReduceIndexBase.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            MapReduceIndexBase.$$$reportNull$$$0(3);
        }
        return ((VfsAwareIndexStorage)this.getStorage()).processKeys(processor, scope, idFilter);
    }

    @Override
    @NotNull
    public Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        Map map;
        try {
            map = Collections.unmodifiableMap(ContainerUtil.notNullize(this.getNullableIndexedData(fileId)));
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        if (map == null) {
            MapReduceIndexBase.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    protected Map<Key, Value> getNullableIndexedData(int fileId) throws IOException, StorageException {
        if (this.isDisposed()) {
            return null;
        }
        if (this.mySingleEntryIndex) {
            Integer key = fileId;
            Ref result = new Ref(Collections.emptyMap());
            boolean acceptNullValues = ((SingleEntryIndexer)this.indexer()).isAcceptNullValues();
            this.withData(key, container -> {
                container.forEach((id, value) -> {
                    if (value != null || acceptNullValues) {
                        result.set(Collections.singletonMap(key, value));
                    }
                    return false;
                });
                return !((Map)result.get()).isEmpty();
            });
            return (Map)result.get();
        }
        ForwardIndexAccessor indexAccessor = this.getForwardIndexAccessor();
        if (indexAccessor instanceof AbstractMapForwardIndexAccessor) {
            AbstractMapForwardIndexAccessor forwardIndexAccessor = (AbstractMapForwardIndexAccessor)indexAccessor;
            ForwardIndex forwardIndex = this.getForwardIndex();
            assert (forwardIndex != null) : "forwardIndex must NOT be null if forwardIndexAccessor(" + String.valueOf(forwardIndexAccessor) + ") != null";
            ByteArraySequence serializedInputData = forwardIndex.get(Integer.valueOf(fileId));
            return forwardIndexAccessor.convertToInputDataMap(fileId, serializedInputData);
        }
        this.getLogger().error("Can't fetch indexed data for index=" + String.valueOf(this.indexId()) + ", (accessor: " + String.valueOf(indexAccessor) + ")");
        return null;
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    @Override
    public void setBufferingEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanupMemoryStorage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanupForNextTest() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTransientDataForFile(int inputId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<Key, Value> diffBuilder) {
        if (diffBuilder == null) {
            MapReduceIndexBase.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    protected abstract Logger getLogger();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/storage/MapReduceIndexBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/storage/MapReduceIndexBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

