/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ConcurrentBitSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexableFilesDeduplicateFilter
implements VirtualFileFilter {
    @Nullable
    private final IndexableFilesDeduplicateFilter myDelegate;
    private final ConcurrentBitSet myVisitedFileSet = ConcurrentBitSet.create();
    private final AtomicInteger myNumberOfSkippedFiles = new AtomicInteger();

    private IndexableFilesDeduplicateFilter(@Nullable IndexableFilesDeduplicateFilter delegate) {
        this.myDelegate = delegate;
    }

    @NotNull
    public static IndexableFilesDeduplicateFilter create() {
        return new IndexableFilesDeduplicateFilter(null);
    }

    @NotNull
    public static IndexableFilesDeduplicateFilter createDelegatingTo(@NotNull IndexableFilesDeduplicateFilter delegate) {
        if (delegate == null) {
            IndexableFilesDeduplicateFilter.$$$reportNull$$$0(0);
        }
        if (delegate.myDelegate != null) {
            throw new IllegalStateException("Only one-level delegation is supported now");
        }
        return new IndexableFilesDeduplicateFilter(delegate);
    }

    public int getNumberOfSkippedFiles() {
        return this.myNumberOfSkippedFiles.get();
    }

    public boolean accept(@NotNull VirtualFile file) {
        int fileId;
        if (file == null) {
            IndexableFilesDeduplicateFilter.$$$reportNull$$$0(1);
        }
        if (this.myDelegate != null) {
            boolean shouldVisit = this.myDelegate.accept(file);
            if (!shouldVisit) {
                this.myNumberOfSkippedFiles.incrementAndGet();
            }
            return shouldVisit;
        }
        if (file instanceof VirtualFileWithId && (fileId = ((VirtualFileWithId)file).getId()) > 0) {
            boolean wasVisited = this.myVisitedFileSet.set(fileId);
            if (wasVisited) {
                this.myNumberOfSkippedFiles.incrementAndGet();
            }
            return !wasVisited;
        }
        this.myNumberOfSkippedFiles.incrementAndGet();
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/roots/IndexableFilesDeduplicateFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDelegatingTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

