/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import java.util.Objects;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoAttributes
implements Cloneable {
    private static final String ATTRIBUTE_ICON = "icon";
    private static final String ICON_NULL = "null";
    private static final String ICON_DEFAULT = "default";
    private static final String ICON_QUESTION = "question";
    private static final String ICON_IMPORTANT = "important";
    private static final String ELEMENT_OPTION = "option";
    private static final String USE_CUSTOM_COLORS_ATT = "useCustomColors";
    @Nullable
    private Icon myIcon;
    private TextAttributes myTextAttributes;
    private boolean myShouldUseCustomColors;

    @ApiStatus.Internal
    TodoAttributes(@NotNull Element element, @NotNull TextAttributes defaultTodoAttributes) {
        String icon;
        if (element == null) {
            TodoAttributes.$$$reportNull$$$0(0);
        }
        if (defaultTodoAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(1);
        }
        switch (icon = element.getAttributeValue(ATTRIBUTE_ICON, ICON_NULL)) {
            case "default": {
                this.myIcon = IconManager.getInstance().getPlatformIcon(PlatformIcons.TodoDefault);
                break;
            }
            case "question": {
                this.myIcon = IconManager.getInstance().getPlatformIcon(PlatformIcons.TodoQuestion);
                break;
            }
            case "important": {
                this.myIcon = IconManager.getInstance().getPlatformIcon(PlatformIcons.TodoImportant);
                break;
            }
            case "null": {
                this.myIcon = null;
                break;
            }
            default: {
                throw new InvalidDataException(icon);
            }
        }
        this.myShouldUseCustomColors = Boolean.parseBoolean(element.getAttributeValue(USE_CUSTOM_COLORS_ATT));
        this.myTextAttributes = this.myShouldUseCustomColors && element.getChild(ELEMENT_OPTION) != null ? new TextAttributes(element) : defaultTodoAttributes;
    }

    @ApiStatus.Internal
    public TodoAttributes(@Nullable Icon icon, @NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(2);
        }
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
    }

    @ApiStatus.Internal
    public TodoAttributes(@NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(3);
        }
        this.myTextAttributes = textAttributes;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    @NotNull
    public TextAttributes getTextAttributes() {
        TextAttributes textAttributes = this.getCustomizedTextAttributes();
        if (textAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(4);
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getCustomizedTextAttributes() {
        TextAttributes textAttributes = this.myTextAttributes;
        if (textAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(5);
        }
        return textAttributes;
    }

    public boolean shouldUseCustomTodoColor() {
        return this.myShouldUseCustomColors;
    }

    public void setUseCustomTodoColor(boolean useCustomColors, @NotNull TextAttributes defaultTodoAttributes) {
        if (defaultTodoAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(6);
        }
        this.myShouldUseCustomColors = useCustomColors;
        if (!useCustomColors) {
            this.myTextAttributes = defaultTodoAttributes;
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            TodoAttributes.$$$reportNull$$$0(7);
        }
        String icon = null;
        IconManager iconManager = IconManager.getInstance();
        if (this.myIcon == iconManager.getPlatformIcon(PlatformIcons.TodoQuestion)) {
            icon = ICON_QUESTION;
        } else if (this.myIcon == iconManager.getPlatformIcon(PlatformIcons.TodoImportant)) {
            icon = ICON_IMPORTANT;
        } else if (this.myIcon == iconManager.getPlatformIcon(PlatformIcons.TodoDefault)) {
            icon = ICON_DEFAULT;
        }
        if (icon != null) {
            element.setAttribute(ATTRIBUTE_ICON, icon);
        }
        if (this.shouldUseCustomTodoColor()) {
            this.myTextAttributes.writeExternal(element);
            element.setAttribute(USE_CUSTOM_COLORS_ATT, "true");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TodoAttributes)) {
            return false;
        }
        TodoAttributes attributes = (TodoAttributes)o;
        return this.myIcon == attributes.myIcon && Objects.equals(this.myTextAttributes, attributes.myTextAttributes) && this.myShouldUseCustomColors == attributes.myShouldUseCustomColors;
    }

    public int hashCode() {
        int result = this.myIcon != null ? this.myIcon.hashCode() : 0;
        result = 29 * result + (this.myTextAttributes != null ? this.myTextAttributes.hashCode() : 0);
        result = 29 * result + Boolean.valueOf(this.myShouldUseCustomColors).hashCode();
        return result;
    }

    public TodoAttributes clone() {
        TodoAttributes attributes = new TodoAttributes(this.myIcon, this.myTextAttributes.clone());
        attributes.myShouldUseCustomColors = this.myShouldUseCustomColors;
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTodoAttributes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/TodoAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/TodoAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizedTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUseCustomTodoColor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

