/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.BitSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class IdFilter {
    private static final Logger LOG = Logger.getInstance(IdFilter.class);
    private static final Key<CachedValue<IdFilter>> INSIDE_PROJECT = Key.create((String)"INSIDE_PROJECT");
    public static final IdFilter ACCEPT_ALL = new IdFilter(){

        @Override
        public boolean containsFileId(int id) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };

    @NotNull
    public static IdFilter getProjectIdFilter(@NotNull Project project, boolean includeNonProjectItems) {
        if (project == null) {
            IdFilter.$$$reportNull$$$0(0);
        }
        if (includeNonProjectItems) {
            IdFilter filter = FileBasedIndex.getInstance().projectIndexableFiles(project);
            return filter != null ? filter : new IdFilter(){

                @Override
                public boolean containsFileId(int id) {
                    return false;
                }
            };
        }
        CachedValueProvider provider = () -> CachedValueProvider.Result.create((Object)IdFilter.buildProjectIdFilterForContentFiles(project), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        IdFilter idFilter = (IdFilter)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, INSIDE_PROJECT, provider, false);
        if (idFilter == null) {
            IdFilter.$$$reportNull$$$0(1);
        }
        return idFilter;
    }

    @NotNull
    private static IdFilter buildProjectIdFilterForContentFiles(@NotNull Project project) {
        if (project == null) {
            IdFilter.$$$reportNull$$$0(2);
        }
        long started = System.currentTimeMillis();
        final BitSet idSet = new BitSet();
        ContentIterator iterator = fileOrDir -> {
            idSet.set(((VirtualFileWithId)fileOrDir).getId());
            ProgressManager.checkCanceled();
            return true;
        };
        ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContent(iterator);
        if (LOG.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - started;
            LOG.debug("Done filter (includeNonProjectItems=false) in " + elapsed + "ms. Total files in set: " + idSet.cardinality());
        }
        return new IdFilter(){

            @Override
            public boolean containsFileId(int id) {
                return id >= 0 && idSet.get(id);
            }

            @Override
            @NotNull
            public FilterScopeType getFilteringScopeType() {
                FilterScopeType filterScopeType = FilterScopeType.PROJECT;
                if (filterScopeType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return filterScopeType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IdFilter$2", "getFilteringScopeType"));
            }
        };
    }

    public abstract boolean containsFileId(int var1);

    @ApiStatus.Internal
    @NotNull
    public FilterScopeType getFilteringScopeType() {
        FilterScopeType filterScopeType = FilterScopeType.OTHER;
        if (filterScopeType == null) {
            IdFilter.$$$reportNull$$$0(3);
        }
        return filterScopeType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IdFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IdFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectIdFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteringScopeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectIdFilter";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildProjectIdFilterForContentFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static enum FilterScopeType {
        OTHER{

            @Override
            @NonNls
            @NotNull
            public String getId() {
                throw new UnsupportedOperationException();
            }
        }
        ,
        PROJECT{

            @Override
            @NonNls
            @NotNull
            public String getId() {
                return "false";
            }
        }
        ,
        PROJECT_AND_LIBRARIES{

            @Override
            @NonNls
            @NotNull
            public String getId() {
                return "true";
            }
        };


        @NonNls
        @NotNull
        public abstract String getId();
    }
}

