/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.hash;

import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.StorageLockContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ContentHashEnumeratorOverBTree
extends PersistentBTreeEnumerator<byte[]>
implements ContentHashEnumerator {
    public ContentHashEnumeratorOverBTree(@NotNull Path contentsHashesFile) throws IOException {
        if (contentsHashesFile == null) {
            ContentHashEnumeratorOverBTree.$$$reportNull$$$0(0);
        }
        this(contentsHashesFile, null);
    }

    ContentHashEnumeratorOverBTree(@NotNull Path contentsHashesFile, @Nullable StorageLockContext storageLockContext) throws IOException {
        if (contentsHashesFile == null) {
            ContentHashEnumeratorOverBTree.$$$reportNull$$$0(1);
        }
        this(contentsHashesFile, new ContentHashesDescriptor(), 65536, storageLockContext);
    }

    private ContentHashEnumeratorOverBTree(@NotNull Path file, @NotNull KeyDescriptor<byte[]> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        if (file == null) {
            ContentHashEnumeratorOverBTree.$$$reportNull$$$0(2);
        }
        if (dataDescriptor == null) {
            ContentHashEnumeratorOverBTree.$$$reportNull$$$0(3);
        }
        super(file, dataDescriptor, initialSize, lockContext);
        LOG.assertTrue(dataDescriptor instanceof DifferentSerializableBytesImplyNonEqualityPolicy);
    }

    public boolean hasHashFor(byte @NotNull [] value) throws IOException {
        if (value == null) {
            ContentHashEnumeratorOverBTree.$$$reportNull$$$0(4);
        }
        return this.tryEnumerate(value) != 0;
    }

    public int getLargestId() {
        return super.getLargestId() / 20;
    }

    @Override
    public int enumerate(byte @NotNull [] hash) throws IOException {
        if (hash == null) {
            ContentHashEnumeratorOverBTree.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(20 == hash.length);
        return super.enumerate((Object)hash);
    }

    @Override
    public int enumerateEx(byte @NotNull [] hash) throws IOException {
        if (hash == null) {
            ContentHashEnumeratorOverBTree.$$$reportNull$$$0(6);
        }
        int largestId = this.getLargestId();
        int id = this.enumerate(hash);
        if (id > largestId) {
            return id;
        }
        return -id;
    }

    protected int doWriteData(byte[] value) throws IOException {
        return super.doWriteData((Object)value) / 20;
    }

    protected boolean isKeyAtIndex(byte[] value, int idx) throws IOException {
        return super.isKeyAtIndex((Object)value, this.addrToIndex(this.indexToAddr(idx) * 20));
    }

    @Override
    public byte[] valueOf(int idx) throws IOException {
        return (byte[])super.valueOf(this.addrToIndex(this.indexToAddr(idx) * 20));
    }

    public static int getVersion() {
        return PersistentBTreeEnumerator.baseVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentsHashesFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/hash/ContentHashEnumeratorOverBTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasHashFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enumerate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "enumerateEx";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ContentHashesDescriptor
    implements KeyDescriptor<byte[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private ContentHashesDescriptor() {
        }

        public void save(@NotNull DataOutput out, byte[] value) throws IOException {
            if (out == null) {
                ContentHashesDescriptor.$$$reportNull$$$0(0);
            }
            out.write(value);
        }

        public byte[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ContentHashesDescriptor.$$$reportNull$$$0(1);
            }
            byte[] b = new byte[20];
            in.readFully(b);
            return b;
        }

        public int getHashCode(byte[] value) {
            int hash = 0;
            for (int i = 0; i < 4; ++i) {
                hash = (hash << 8) + (value[i] & 0xFF);
            }
            return hash;
        }

        public boolean isEqual(byte[] val1, byte[] val2) {
            return Arrays.equals(val1, val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/hash/ContentHashEnumeratorOverBTree$ContentHashesDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

