/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.instanceContainer.internal;

import com.intellij.platform.instanceContainer.internal.InstanceHolder;
import com.intellij.util.NotNullizer;
import com.intellij.util.containers.UtilKt;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B9\b\u0002\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0004\b\n\u0010\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u0004J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tJ\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u0013\u001a\u00020\u00002\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0012\u001a\u00020\u0005R \u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/instanceContainer/internal/InstanceContainerState;", "", "holders", "", "", "Lcom/intellij/platform/instanceContainer/internal/InstanceHolder;", "Lcom/intellij/platform/instanceContainer/internal/InstanceHolders;", "cache", "Lkotlinx/collections/immutable/PersistentMap;", "Ljava/lang/Class;", "<init>", "(Ljava/util/Map;Lkotlinx/collections/immutable/PersistentMap;)V", "(Ljava/util/Map;)V", "getByName", "keyClassName", "getByClass", "keyClass", "replaceByName", "holder", "replaceByClass", "Companion", "intellij.platform.instanceContainer"})
public final class InstanceContainerState {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Map<String, InstanceHolder> holders;
    @NotNull
    private PersistentMap<Class<?>, ? extends InstanceHolder> cache;
    @Deprecated
    @JvmField
    @NotNull
    public static final NotNullizer notNullizer = new NotNullizer("InstanceContainerState.Nothing");
    @Deprecated
    @JvmField
    @NotNull
    public static final VarHandle cacheHandle;

    private InstanceContainerState(Map<String, ? extends InstanceHolder> holders, PersistentMap<Class<?>, ? extends InstanceHolder> cache) {
        this.holders = holders;
        this.cache = cache;
    }

    public InstanceContainerState(@NotNull Map<String, ? extends InstanceHolder> holders) {
        Intrinsics.checkNotNullParameter(holders, (String)"holders");
        this(holders, ExtensionsKt.persistentHashMapOf());
    }

    @Nullable
    public final InstanceHolder getByName(@NotNull String keyClassName) {
        Intrinsics.checkNotNullParameter((Object)keyClassName, (String)"keyClassName");
        return this.holders.get(keyClassName);
    }

    @Nullable
    public final InstanceHolder getByClass(@NotNull Class<?> keyClass) {
        Intrinsics.checkNotNullParameter(keyClass, (String)"keyClass");
        PersistentMap cache = cacheHandle.getVolatile(this);
        Object cached;
        while ((cached = cache.get(keyClass)) == null) {
            String string = keyClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            InstanceHolder holder = this.getByName(string);
            Object object = notNullizer.notNullize((Object)holder);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"notNullize(...)");
            PersistentMap newValue = cache.put(keyClass, object);
            Object witness = cacheHandle.compareAndExchange(this, cache, newValue);
            if (witness == cache) {
                return holder;
            }
            Intrinsics.checkNotNull((Object)witness, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.PersistentMap<kotlin.Any, kotlin.Any>");
            cache = (PersistentMap)witness;
        }
        return (InstanceHolder)notNullizer.nullize(cached);
    }

    @NotNull
    public final InstanceContainerState replaceByName(@NotNull String keyClassName, @Nullable InstanceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)keyClassName, (String)"keyClassName");
        Map newHolders = holder == null ? UtilKt.without(this.holders, (Object)keyClassName) : UtilKt.with(this.holders, (Object)keyClassName, (Object)holder);
        return new InstanceContainerState(newHolders);
    }

    @NotNull
    public final InstanceContainerState replaceByClass(@NotNull Class<?> keyClass, @NotNull InstanceHolder holder) {
        Intrinsics.checkNotNullParameter(keyClass, (String)"keyClass");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = keyClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new InstanceContainerState(UtilKt.with(this.holders, (Object)string, (Object)holder), this.cache.put(keyClass, (Object)holder));
    }

    static {
        VarHandle varHandle = MethodHandles.lookup().findVarHandle(InstanceContainerState.class, "cache", PersistentMap.class);
        Intrinsics.checkNotNullExpressionValue((Object)varHandle, (String)"findVarHandle(...)");
        cacheHandle = varHandle;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/instanceContainer/internal/InstanceContainerState$Companion;", "", "<init>", "()V", "notNullizer", "Lcom/intellij/util/NotNullizer;", "cacheHandle", "Ljava/lang/invoke/VarHandle;", "intellij.platform.instanceContainer"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

