/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.jarRepository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoriesConfiguration;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;

final class JpsRemoteRepositoriesConfigurationImpl
extends JpsElementBase<JpsRemoteRepositoriesConfigurationImpl>
implements JpsRemoteRepositoriesConfiguration {
    public static final JpsElementChildRole<JpsRemoteRepositoriesConfiguration> ROLE = JpsElementChildRoleBase.create((String)"remote repositories configuration");
    private final List<JpsRemoteRepositoryDescription> repositories = new ArrayList<JpsRemoteRepositoryDescription>();

    JpsRemoteRepositoriesConfigurationImpl() {
        this(Arrays.asList(new JpsRemoteRepositoryDescription("central", "Maven Central repository", "https://repo1.maven.org/maven2"), new JpsRemoteRepositoryDescription("jboss.community", "JBoss Community repository", "https://repository.jboss.org/nexus/content/repositories/public/")));
    }

    public JpsRemoteRepositoriesConfigurationImpl(List<? extends JpsRemoteRepositoryDescription> repositories) {
        this.repositories.addAll(repositories);
    }

    @NotNull
    public JpsRemoteRepositoriesConfigurationImpl createCopy() {
        return new JpsRemoteRepositoriesConfigurationImpl(this.repositories);
    }

    public List<JpsRemoteRepositoryDescription> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public void setRepositories(List<? extends JpsRemoteRepositoryDescription> repositories) {
        this.repositories.clear();
        this.repositories.addAll(repositories);
    }
}

