/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSettingsProvider
implements CustomCodeStyleSettingsFactory,
DisplayPrioritySortable {
    public static final ExtensionPointName<CodeStyleSettingsProvider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.codeStyleSettingsProvider");

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Deprecated
    @NotNull
    public Configurable createSettingsPage(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        if (settings == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (modelSettings == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (null == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public String getConfigurableId() {
        Language language = this.getLanguage();
        if (language != null) {
            String string = CodeStyleSettings.generateConfigurableIdByLanguage((Language)language);
            if (string == null) {
                CodeStyleSettingsProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        Logger logger = Logger.getInstance(this.getClass());
        String displayName = this.getConfigurableDisplayName();
        if (displayName == null) {
            PluginException.logPluginError((Logger)logger, (String)("Cannot determine id for configurable provider " + String.valueOf(this.getClass()) + ". Please override getConfigurableId or getLanguage."), null, this.getClass());
            return "preferences.sourceCode.null";
        }
        PluginException.logPluginError((Logger)logger, (String)("Legacy configurable id calculation mode from localizable name will be used for configurable " + String.valueOf(this.getClass()) + ". Please override getConfigurableId or getLanguage."), null, this.getClass());
        String string = "preferences.sourceCode." + displayName;
        if (string == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        Configurable configurable;
        if (settings == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (modelSettings == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if ((configurable = this.createSettingsPage(settings, modelSettings)) instanceof CodeStyleConfigurable) {
            CodeStyleConfigurable codeStyleConfigurable = (CodeStyleConfigurable)configurable;
            if (codeStyleConfigurable == null) {
                CodeStyleSettingsProvider.$$$reportNull$$$0(8);
            }
            return codeStyleConfigurable;
        }
        return new LegacyConfigurableWrapper(configurable);
    }

    @NlsContexts.ConfigurableName
    @Nullable
    public String getConfigurableDisplayName() {
        Language lang = this.getLanguage();
        return lang == null ? null : lang.getDisplayName();
    }

    public boolean hasSettingsPage() {
        return true;
    }

    @Override
    public DisplayPriority getPriority() {
        List primaryIdeLanguages = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages();
        return primaryIdeLanguages.contains(this.getLanguage()) ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    @Nullable
    public Language getLanguage() {
        return null;
    }

    @Nullable
    public CodeStyleGroup getGroup() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsPage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8 -> new IllegalStateException(string);
        };
    }

    private static final class LegacyConfigurableWrapper
    implements CodeStyleConfigurable {
        @NotNull
        private final Configurable myConfigurable;

        private LegacyConfigurableWrapper(@NotNull Configurable configurable) {
            if (configurable == null) {
                LegacyConfigurableWrapper.$$$reportNull$$$0(0);
            }
            this.myConfigurable = configurable;
        }

        @Override
        public void reset(@NotNull CodeStyleSettings settings) {
            if (settings == null) {
                LegacyConfigurableWrapper.$$$reportNull$$$0(1);
            }
            this.myConfigurable.reset();
        }

        @Override
        public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
            if (settings == null) {
                LegacyConfigurableWrapper.$$$reportNull$$$0(2);
            }
            this.myConfigurable.apply();
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myConfigurable.getDisplayName();
        }

        @Nullable
        public JComponent createComponent() {
            return this.myConfigurable.createComponent();
        }

        public boolean isModified() {
            return this.myConfigurable.isModified();
        }

        public void apply() throws ConfigurationException {
            this.myConfigurable.apply();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsProvider$LegacyConfigurableWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

