/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor;

import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.values.Generation;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.util.MathUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    public static final int CRITICAL_SYMBOL_WEIGHT = 100;
    static long rseed = 0L;
    static final long RAND_MAX_32 = Integer.MAX_VALUE;
    static final long RAND_MAX = 32767L;

    public static void logError(String message) {
        System.out.println(message);
    }

    @Contract(pure=true)
    public static int getTabSize(@Nullable CommonCodeStyleSettings.IndentOptions options) {
        return options == null ? 4 : options.TAB_SIZE;
    }

    public static int getNormalizedLength(@Nullable CommonCodeStyleSettings.IndentOptions options, @NotNull String text) {
        if (text == null) {
            Utils.$$$reportNull$$$0(0);
        }
        return text.replaceAll("\t", StringUtil.repeatSymbol((char)' ', (int)Utils.getTabSize(options))).replaceAll("\n", StringUtil.repeatSymbol((char)' ', (int)100)).length();
    }

    @Contract(pure=true)
    public static boolean isSpace(char c) {
        return " \t\n".indexOf(c) >= 0;
    }

    @Contract(pure=true)
    public static boolean isBracket(char c) {
        return "(){}[]<>".indexOf(c) >= 0;
    }

    public static int getDiff(@Nullable CommonCodeStyleSettings.IndentOptions options, @NotNull String oldV, @NotNull String newV) {
        if (oldV == null) {
            Utils.$$$reportNull$$$0(1);
        }
        if (newV == null) {
            Utils.$$$reportNull$$$0(2);
        }
        oldV = oldV.trim();
        newV = newV.trim();
        int diff = 0;
        int oPos = 0;
        int nPos = 0;
        int oEnd = oldV.length();
        int nEnd = newV.length();
        StringBuilder oSp = new StringBuilder();
        StringBuilder nSp = new StringBuilder();
        while (oPos < oEnd || nPos < nEnd) {
            char ch;
            oSp.setLength(0);
            nSp.setLength(0);
            while (oPos < oEnd && Utils.isSpace(ch = oldV.charAt(oPos))) {
                oSp.append(ch);
                ++oPos;
            }
            while (nPos < nEnd && Utils.isSpace(ch = newV.charAt(nPos))) {
                nSp.append(ch);
                ++nPos;
            }
            diff += Math.abs(Utils.getNormalizedLength(options, oSp.toString()) - Utils.getNormalizedLength(options, nSp.toString()));
            while (oPos < oEnd && nPos < nEnd && (ch = oldV.charAt(oPos)) == newV.charAt(nPos) && !Utils.isSpace(ch)) {
                ++oPos;
                ++nPos;
            }
            if (oPos >= oEnd || nPos >= nEnd || Utils.isSpace(oldV.charAt(oPos)) || Utils.isSpace(newV.charAt(nPos))) continue;
            Utils.logError("AST changed!");
            return 0x1FFFFFFF;
        }
        return diff;
    }

    @Nullable
    public static CustomCodeStyleSettings getLanguageSettings(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        if (settings == null) {
            Utils.$$$reportNull$$$0(3);
        }
        if (language == null) {
            Utils.$$$reportNull$$$0(4);
        }
        for (CodeStyleSettingsProvider provider : (CodeStyleSettingsProvider[])CodeStyleSettingsProvider.EXTENSION_POINT_NAME.getExtensions()) {
            CustomCodeStyleSettings modelSettings;
            if (!language.equals(provider.getLanguage()) || (modelSettings = provider.createCustomSettings(settings)) == null) continue;
            return settings.getCustomSettings(modelSettings.getClass());
        }
        Utils.logError("Failed to load CustomCodeStyleSettings for " + String.valueOf(language));
        return null;
    }

    public static void adjustValuesMin(@NotNull ValuesExtractionResult gens, @NotNull Differ differ, @Nullable ProgressIndicator indicator) {
        if (gens == null) {
            Utils.$$$reportNull$$$0(5);
        }
        if (differ == null) {
            Utils.$$$reportNull$$$0(6);
        }
        List<Value> values = gens.getValues();
        int length = values.size();
        int i = 0;
        for (Value value : values) {
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setText2(LangBundle.message("progress.details.value", value.name));
                indicator.setFraction(0.5 + 0.5 * (double)i / (double)length);
            }
            Object bestValue = value.value;
            int bestScope = differ.getDifference(gens);
            for (Object cnst : value.getPossibleValues()) {
                if (cnst.equals(value.value)) continue;
                value.value = cnst;
                int diff = differ.getDifference(gens);
                if (diff < bestScope) {
                    bestValue = cnst;
                    bestScope = diff;
                    value.state = Value.STATE.SELECTED;
                    continue;
                }
                if (diff <= bestScope) continue;
                value.state = Value.STATE.SELECTED;
            }
            value.value = bestValue;
            ++i;
        }
    }

    public static void adjustValuesGA(@NotNull Gens gens, @NotNull Differ differ, @Nullable ProgressIndicator indicator) {
        if (gens == null) {
            Utils.$$$reportNull$$$0(7);
        }
        if (differ == null) {
            Utils.$$$reportNull$$$0(8);
        }
        Generation generation = Generation.createZeroGeneration(gens);
        while (generation.tryAgain()) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            int age = generation.getAge();
            if (indicator != null) {
                indicator.setText2(LangBundle.message("progress.details.age.defects", age, generation.getParentKind()));
                indicator.setFraction(0.5 * (double)age / (double)Generation.GEN_COUNT);
            }
            generation = Generation.createNextGeneration(differ, generation);
        }
        gens.copyFrom(generation.getBestGens(differ));
    }

    public static void resetRandom() {
        rseed = 0L;
    }

    public static long getRandom() {
        rseed = rseed * 214013L + 2531011L & Integer.MAX_VALUE;
        return rseed >> 16;
    }

    public static int getRandomLess(int count) {
        int ret = (int)(Utils.getRandom() * (long)count / 32767L);
        return MathUtil.clamp((int)ret, (int)0, (int)(count - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldV";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newV";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gens";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "differ";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/extractor/Utils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNormalizedLength";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDiff";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguageSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustValuesMin";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustValuesGA";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

