/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.util.NlsContexts;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B,\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB%\b\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\fJ\u0006\u0010\u0017\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u0014\u0010\u001d\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005H\u00c2\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J2\u0010\u001f\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u0013\b\u0002\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR'\u0010\u0012\u001a\u000f\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/codeInsight/hints/Option;", "", "id", "", "nameSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "defaultValue", "", "<init>", "(Ljava/lang/String;Ljava/util/function/Supplier;Z)V", "name", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getId", "()Ljava/lang/String;", "getDefaultValue", "()Z", "getName", "extendedDescriptionSupplier", "getExtendedDescriptionSupplier", "()Ljava/util/function/Supplier;", "setExtendedDescriptionSupplier", "(Ljava/util/function/Supplier;)V", "isEnabled", "get", "set", "", "newValue", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.lang"})
public final class Option {
    @NotNull
    private final String id;
    @NotNull
    private final Supplier<String> nameSupplier;
    private final boolean defaultValue;
    @Nullable
    private Supplier<String> extendedDescriptionSupplier;

    public Option(@NonNls @NotNull String id, @NotNull Supplier<String> nameSupplier, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(nameSupplier, (String)"nameSupplier");
        this.id = id;
        this.nameSupplier = nameSupplier;
        this.defaultValue = defaultValue;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Deprecated(message="Use default constructor")
    public Option(@NonNls @NotNull String id, @Nls @NotNull String name, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(id, () -> Option._init_$lambda$0(name), defaultValue);
    }

    @NlsContexts.DetailedDescription
    @NotNull
    public final String getName() {
        String string = this.nameSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    @Nullable
    public final Supplier<String> getExtendedDescriptionSupplier() {
        return this.extendedDescriptionSupplier;
    }

    public final void setExtendedDescriptionSupplier(@Nullable Supplier<String> supplier) {
        this.extendedDescriptionSupplier = supplier;
    }

    public final boolean isEnabled() {
        return this.get();
    }

    public final boolean get() {
        Boolean bl = ParameterNameHintsSettings.Companion.getInstance().getOption(this.id);
        return bl != null ? bl : this.defaultValue;
    }

    public final void set(boolean newValue) {
        ParameterNameHintsSettings settings = ParameterNameHintsSettings.Companion.getInstance();
        if (newValue == this.defaultValue) {
            settings.setOption(this.id, null);
        } else {
            settings.setOption(this.id, newValue);
        }
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    private final Supplier<String> component2() {
        return this.nameSupplier;
    }

    public final boolean component3() {
        return this.defaultValue;
    }

    @NotNull
    public final Option copy(@NonNls @NotNull String id, @NotNull Supplier<String> nameSupplier, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(nameSupplier, (String)"nameSupplier");
        return new Option(id, nameSupplier, defaultValue);
    }

    public static /* synthetic */ Option copy$default(Option option, String string, Supplier supplier, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = option.id;
        }
        if ((n & 2) != 0) {
            supplier = option.nameSupplier;
        }
        if ((n & 4) != 0) {
            bl = option.defaultValue;
        }
        return option.copy(string, supplier, bl);
    }

    @NotNull
    public String toString() {
        return "Option(id=" + this.id + ", nameSupplier=" + this.nameSupplier + ", defaultValue=" + this.defaultValue + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.nameSupplier.hashCode();
        result = result * 31 + Boolean.hashCode(this.defaultValue);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Option)) {
            return false;
        }
        Option option = (Option)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)option.id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.nameSupplier, option.nameSupplier)) {
            return false;
        }
        return this.defaultValue == option.defaultValue;
    }

    private static final String _init_$lambda$0(String $name) {
        return $name;
    }
}

