/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.ContentKey;
import com.intellij.codeInsight.hints.InlayKey;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 -2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002-.B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010+\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006/"}, d2={"Lcom/intellij/codeInsight/hints/presentation/RecursivelyUpdatingRootPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "Lcom/intellij/codeInsight/hints/presentation/RootInlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "current", "<init>", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)V", "listener", "Lcom/intellij/codeInsight/hints/presentation/RecursivelyUpdatingRootPresentation$MyPresentationListener;", "update", "", "newPresentationContent", "editor", "Lcom/intellij/openapi/editor/Editor;", "factory", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory;", "content", "getContent", "()Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "key", "Lcom/intellij/codeInsight/hints/ContentKey;", "getKey", "()Lcom/intellij/codeInsight/hints/ContentKey;", "width", "", "getWidth", "()I", "height", "getHeight", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "mouseClicked", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mousePressed", "mouseMoved", "mouseExited", "Companion", "MyPresentationListener", "intellij.platform.lang"})
public class RecursivelyUpdatingRootPresentation
extends BasePresentation
implements RootInlayPresentation<InlayPresentation> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private InlayPresentation current;
    @NotNull
    private MyPresentationListener listener;
    @NotNull
    private static final ContentKey<InlayPresentation> KEY = new InlayKey("recursive.update.root");

    public RecursivelyUpdatingRootPresentation(@NotNull InlayPresentation current) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        this.current = current;
        this.listener = new MyPresentationListener();
        this.current.addListener(this.listener);
    }

    @Override
    public boolean update(@NotNull InlayPresentation newPresentationContent, @NotNull Editor editor, @NotNull InlayPresentationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)newPresentationContent, (String)"newPresentationContent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        InlayPresentation previous = this.current;
        this.current.removeListener(this.listener);
        this.current = newPresentationContent;
        this.listener = new MyPresentationListener();
        this.current.addListener(this.listener);
        Dimension previousDimension = new Dimension(previous.getWidth(), previous.getHeight());
        boolean updated = newPresentationContent.updateState(previous);
        if (updated) {
            this.fireContentChanged(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            Dimension currentDimension = new Dimension(this.getWidth(), this.getHeight());
            if (!Intrinsics.areEqual((Object)previousDimension, (Object)currentDimension)) {
                this.fireSizeChanged(previousDimension, currentDimension);
            }
        }
        return updated;
    }

    @Override
    @NotNull
    public InlayPresentation getContent() {
        return this.current;
    }

    @Override
    @NotNull
    public ContentKey<InlayPresentation> getKey() {
        return KEY;
    }

    @Override
    public int getWidth() {
        return this.current.getWidth();
    }

    @Override
    public int getHeight() {
        return this.current.getHeight();
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.current.paint(g, attributes);
    }

    @Override
    @NotNull
    public String toString() {
        return this.current.toString();
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.current.mouseClicked(event, translated);
    }

    @Override
    public void mousePressed(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.current.mousePressed(event, translated);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.current.mouseMoved(event, translated);
    }

    @Override
    public void mouseExited() {
        this.current.mouseExited();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/presentation/RecursivelyUpdatingRootPresentation$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/codeInsight/hints/ContentKey;", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "intellij.platform.lang"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/hints/presentation/RecursivelyUpdatingRootPresentation$MyPresentationListener;", "Lcom/intellij/codeInsight/hints/presentation/PresentationListener;", "<init>", "(Lcom/intellij/codeInsight/hints/presentation/RecursivelyUpdatingRootPresentation;)V", "contentChanged", "", "area", "Ljava/awt/Rectangle;", "sizeChanged", "previous", "Ljava/awt/Dimension;", "current", "intellij.platform.lang"})
    public final class MyPresentationListener
    implements PresentationListener {
        @Override
        public void contentChanged(@NotNull Rectangle area) {
            Intrinsics.checkNotNullParameter((Object)area, (String)"area");
            RecursivelyUpdatingRootPresentation.this.fireContentChanged(area);
        }

        @Override
        public void sizeChanged(@NotNull Dimension previous, @NotNull Dimension current) {
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            RecursivelyUpdatingRootPresentation.this.fireSizeChanged(previous, current);
        }
    }
}

