/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProviderService;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class LanguageCodeStyleSettingsProvider
extends CodeStyleSettingsProvider
implements LanguageCodeStyleProvider {
    public static final ExtensionPointName<LanguageCodeStyleSettingsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.langCodeStyleSettingsProvider");
    private static final AtomicReference<Set<LanguageCodeStyleSettingsProvider>> ourSettingsPagesProviders = new AtomicReference();

    @TestOnly
    @ApiStatus.Internal
    public static void mockLanguageCodeStyleSettingsProviderService(BiConsumer<Class<?>, Object> registrar) {
        registrar.accept(LanguageCodeStyleSettingsProviderService.class, new LanguageCodeStyleSettingsProviderService(true));
    }

    @NotNull
    public static List<LanguageCodeStyleSettingsProvider> getAllProviders() {
        List<LanguageCodeStyleSettingsProvider> list = LanguageCodeStyleSettingsProviderService.getInstance().getAllProviders();
        if (list == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public abstract String getCodeSample(@NotNull SettingsType var1);

    public int getRightMargin(@NotNull SettingsType settingsType) {
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return settingsType == SettingsType.WRAPPING_AND_BRACES_SETTINGS ? 30 : -1;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull SettingsType settingsType) {
        if (consumer == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
    }

    @Nullable
    public static CommonCodeStyleSettings getDefaultCommonSettings(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getDefaultCommonSettings() : null;
    }

    @Nullable
    public String getFileExt() {
        return null;
    }

    @NlsContexts.Label
    @Nullable
    public String getLanguageName() {
        return null;
    }

    @NotNull
    public String getExternalLanguageId() {
        String string = LanguageCodeStyleSettingsProvider.sanitizeLanguageId(StringUtil.toLowerCase((String)this.getLanguage().getID()));
        if (string == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static String sanitizeLanguageId(@NotNull String id) {
        if (id == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder(id.length());
        id.chars().forEach(c -> {
            if (c >= 97 && c <= 122) {
                sb.appendCodePoint(c);
            } else {
                sb.append('-');
            }
        });
        return sb.toString();
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (text == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Deprecated
    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings(this.getLanguage());
        defaultSettings.initIndentOptions();
        this.customizeDefaults(defaultSettings, defaultSettings.getIndentOptions());
        CommonCodeStyleSettings commonCodeStyleSettings = defaultSettings;
        if (commonCodeStyleSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return commonCodeStyleSettings;
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        if (indentOptions == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
    }

    @Deprecated
    public DisplayPriority getDisplayPriority() {
        return this.getPriority();
    }

    public List<Language> getApplicableLanguages() {
        return LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
    }

    @NotNull
    public static List<Language> getLanguagesWithCodeStyleSettings() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (LanguageCodeStyleSettingsProvider provider : LanguageCodeStyleSettingsProvider.getAllProviders()) {
            if (!provider.hasSettingsPage()) continue;
            languages.add(provider.getLanguage());
        }
        languages.sort((l1, l2) -> Comparing.compare((Comparable)((Object)LanguageCodeStyleSettingsProvider.getLanguageName(l1)), (Comparable)((Object)LanguageCodeStyleSettingsProvider.getLanguageName(l2))));
        ArrayList<Language> arrayList = languages;
        if (arrayList == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    public static String getCodeSample(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider;
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        return (provider = LanguageCodeStyleSettingsProvider.forLanguage(lang)) != null ? provider.getCodeSample(settingsType) : null;
    }

    public static int getRightMargin(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider;
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(13);
        }
        return (provider = LanguageCodeStyleSettingsProvider.forLanguage(lang)) != null ? provider.getRightMargin(settingsType) : -1;
    }

    @Override
    @NotNull
    public abstract Language getLanguage();

    @Nullable
    public static Language getLanguage(String langName) {
        for (LanguageCodeStyleSettingsProvider provider : LanguageCodeStyleSettingsProvider.getAllProviders()) {
            String name = provider.getLanguageName();
            if (name == null) {
                name = provider.getLanguage().getDisplayName();
            }
            if (!langName.equals(name)) continue;
            return provider.getLanguage();
        }
        return null;
    }

    @Nullable
    public static String getFileExt(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getFileExt() : null;
    }

    @NotNull
    @NlsSafe
    public static String getLanguageName(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        String providerLangName = provider != null ? provider.getLanguageName() : null;
        String string = providerLangName != null ? providerLangName : lang.getDisplayName();
        if (string == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider forLanguage(Language language) {
        for (LanguageCodeStyleSettingsProvider provider : LanguageCodeStyleSettingsProvider.getAllProviders()) {
            if (!provider.getLanguage().equals(language)) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider findUsingBaseLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(15);
        }
        for (Language currLang = language; currLang != null; currLang = currLang.getBaseLanguage()) {
            LanguageCodeStyleSettingsProvider curr = LanguageCodeStyleSettingsProvider.forLanguage(currLang);
            if (curr == null) continue;
            return curr;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider findByExternalLanguageId(@NotNull String languageId) {
        if (languageId == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(16);
        }
        return (LanguageCodeStyleSettingsProvider)ContainerUtil.find(LanguageCodeStyleSettingsProvider.getAllProviders(), provider -> provider.getExternalLanguageId().equals(languageId));
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return null;
    }

    public Set<String> getSupportedFields() {
        return new SupportedFieldCollector().collectFields();
    }

    public Set<String> getSupportedFields(SettingsType type) {
        return new SupportedFieldCollector().collectFields(type);
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(17);
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(18);
        }
        return docCommentSettings;
    }

    @Override
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(19);
        }
        if (modelSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(20);
        }
        throw new RuntimeException(this.getClass().getCanonicalName() + " for language #" + this.getLanguage().getID() + " doesn't implement createConfigurable()");
    }

    public static Set<LanguageCodeStyleSettingsProvider> getSettingsPagesProviders() {
        return ourSettingsPagesProviders.updateAndGet(providers -> providers != null ? providers : LanguageCodeStyleSettingsProvider.calcSettingPagesProviders());
    }

    static void cleanSettingsPagesProvidersCache() {
        ourSettingsPagesProviders.set(null);
    }

    @NotNull
    private static Set<LanguageCodeStyleSettingsProvider> calcSettingPagesProviders() {
        HashSet<LanguageCodeStyleSettingsProvider> settingsPagesProviders = new HashSet<LanguageCodeStyleSettingsProvider>();
        for (LanguageCodeStyleSettingsProvider provider : LanguageCodeStyleSettingsProvider.getAllProviders()) {
            LanguageCodeStyleSettingsProvider.registerSettingsPageProvider(settingsPagesProviders, provider);
        }
        HashSet<LanguageCodeStyleSettingsProvider> hashSet = settingsPagesProviders;
        if (hashSet == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @ApiStatus.Internal
    public static void registerSettingsPageProvider(@NotNull LanguageCodeStyleSettingsProvider provider) {
        if (provider == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(22);
        }
        LanguageCodeStyleSettingsProvider.registerSettingsPageProvider(LanguageCodeStyleSettingsProvider.getSettingsPagesProviders(), provider);
    }

    @ApiStatus.Internal
    public static void unregisterSettingsPageProvider(@NotNull LanguageCodeStyleSettingsProvider provider) {
        if (provider == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(23);
        }
        LanguageCodeStyleSettingsProvider.getSettingsPagesProviders().remove(provider);
    }

    private static void registerSettingsPageProvider(@NotNull Set<? super LanguageCodeStyleSettingsProvider> settingsPagesProviders, @NotNull LanguageCodeStyleSettingsProvider provider) {
        if (settingsPagesProviders == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(24);
        }
        if (provider == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(25);
        }
        try {
            Method configMethod = provider.getClass().getMethod("createConfigurable", CodeStyleSettings.class, CodeStyleSettings.class);
            Class<?> declaringClass = configMethod.getDeclaringClass();
            if (!declaringClass.equals(LanguageCodeStyleSettingsProvider.class)) {
                settingsPagesProviders.add(provider);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @ApiStatus.Experimental
    @NotNull
    public final AbstractCodeStylePropertyMapper getPropertyMapper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(26);
        }
        return new LanguageCodeStylePropertyMapper(settings, this.getLanguage(), this.getExternalLanguageId());
    }

    @ApiStatus.Experimental
    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(27);
        }
        if (field == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(28);
        }
        return null;
    }

    public List<CodeStylePropertyAccessor> getAdditionalAccessors(@NotNull Object codeStyleObject) {
        if (codeStyleObject == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(29);
        }
        return Collections.emptyList();
    }

    public boolean supportsExternalFormats() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 9, 10, 12, 13, 15, 16, 17, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsPagesProviders";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProviders";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLanguageId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCommonSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesWithCodeStyleSettings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSettingPagesProviders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeLanguageId";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findUsingBaseLanguage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findByExternalLanguageId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "registerSettingsPageProvider";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unregisterSettingsPageProvider";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMapper";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAccessors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 9, 10, 12, 13, 15, 16, 17, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }

    public static enum SettingsType {
        BLANK_LINES_SETTINGS,
        SPACING_SETTINGS,
        WRAPPING_AND_BRACES_SETTINGS,
        INDENT_SETTINGS,
        COMMENTER_SETTINGS,
        LANGUAGE_SPECIFIC;

    }

    private final class SupportedFieldCollector
    implements CodeStyleSettingsCustomizable {
        private final Set<String> myCollectedFields = new HashSet<String>();
        private SettingsType myCurrSettingsType;

        private SupportedFieldCollector() {
        }

        Set<String> collectFields() {
            SettingsType[] settingsTypeArray = SettingsType.values();
            int n = settingsTypeArray.length;
            for (int i = 0; i < n; ++i) {
                SettingsType settingsType;
                this.myCurrSettingsType = settingsType = settingsTypeArray[i];
                LanguageCodeStyleSettingsProvider.this.customizeSettings(this, settingsType);
            }
            return this.myCollectedFields;
        }

        Set<String> collectFields(SettingsType type) {
            this.myCurrSettingsType = type;
            LanguageCodeStyleSettingsProvider.this.customizeSettings(this, type);
            return this.myCollectedFields;
        }

        @Override
        public void showAllStandardOptions() {
            switch (this.myCurrSettingsType.ordinal()) {
                case 0: {
                    for (CodeStyleSettingsCustomizable.BlankLinesOption blankLinesOption : CodeStyleSettingsCustomizable.BlankLinesOption.values()) {
                        this.myCollectedFields.add(blankLinesOption.name());
                    }
                    break;
                }
                case 1: {
                    for (CodeStyleSettingsCustomizable.SpacingOption spacingOption : CodeStyleSettingsCustomizable.SpacingOption.values()) {
                        this.myCollectedFields.add(spacingOption.name());
                    }
                    break;
                }
                case 2: {
                    for (CodeStyleSettingsCustomizable.WrappingOrBraceOption wrappingOrBraceOption : CodeStyleSettingsCustomizable.WrappingOrBraceOption.values()) {
                        this.myCollectedFields.add(wrappingOrBraceOption.name());
                    }
                    break;
                }
                case 4: {
                    for (CodeStyleSettingsCustomizable.CommenterOption commenterOption : CodeStyleSettingsCustomizable.CommenterOption.values()) {
                        this.myCollectedFields.add(commenterOption.name());
                    }
                    break;
                }
                case 3: {
                    for (CodeStyleSettingsCustomizable.IndentOption indentOption : CodeStyleSettingsCustomizable.IndentOption.values()) {
                        this.myCollectedFields.add(indentOption.name());
                    }
                    break;
                }
            }
        }

        @Override
        public void showStandardOptions(String ... optionNames) {
            ContainerUtil.addAll(this.myCollectedFields, (Object[])optionNames);
        }

        @Override
        public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title, @Nls @Nullable String groupName, Object ... options) {
            if (settingsClass == null) {
                SupportedFieldCollector.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                SupportedFieldCollector.$$$reportNull$$$0(1);
            }
            if (title == null) {
                SupportedFieldCollector.$$$reportNull$$$0(2);
            }
            this.myCollectedFields.add(fieldName);
        }

        @Override
        public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title, @Nls @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @NonNls @Nullable String anchorFieldName, Object ... options) {
            if (settingsClass == null) {
                SupportedFieldCollector.$$$reportNull$$$0(3);
            }
            if (fieldName == null) {
                SupportedFieldCollector.$$$reportNull$$$0(4);
            }
            if (title == null) {
                SupportedFieldCollector.$$$reportNull$$$0(5);
            }
            this.myCollectedFields.add(fieldName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingsClass";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SupportedFieldCollector";
            objectArray[2] = "showCustomOption";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

