/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCodeInsightAction
extends CodeInsightAction {
    private final boolean lookForInjectedEditor;

    protected BaseCodeInsightAction() {
        this(true);
    }

    protected BaseCodeInsightAction(boolean lookForInjectedEditor) {
        this.lookForInjectedEditor = lookForInjectedEditor;
    }

    @Override
    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project, boolean forUpdate) {
        if (dataContext == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(1);
        }
        Editor editor = this.getBaseEditor(dataContext, project);
        return this.lookForInjectedEditor ? BaseCodeInsightAction.getInjectedEditor(project, editor, !forUpdate) : editor;
    }

    public static Editor getInjectedEditor(@NotNull Project project, Editor editor) {
        if (project == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(2);
        }
        return BaseCodeInsightAction.getInjectedEditor(project, editor, true);
    }

    public static Editor getInjectedEditor(@NotNull Project project, Editor editor, boolean commit) {
        if (project == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return editor;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = documentManager.getCachedPsiFile(editor.getDocument());
        if (psiFile == null) {
            return editor;
        }
        if (commit) {
            documentManager.commitAllDocuments();
        }
        return InjectedLanguageEditorUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)psiFile);
    }

    @Nullable
    protected Editor getBaseEditor(@NotNull DataContext dataContext, @NotNull Project project) {
        if (dataContext == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(5);
        }
        return super.getEditor(dataContext, project, true);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(6);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        LookupEx activeLookup = LookupManager.getInstance((Project)project).getActiveLookup();
        if (activeLookup == null) {
            super.update(event);
        } else {
            presentation.setEnabled(this.isValidForLookup());
        }
    }

    protected boolean isValidForLookup() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/BaseCodeInsightAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectedEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

