/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    private static final Logger LOG = Logger.getInstance(MergeableLineMarkerInfo.class);
    private @Nullable Function<? super PsiElement, @Nls(capitalization=Nls.Capitalization.Title) String> myPresentationProvider;

    @Deprecated
    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, @Nullable Icon icon, int __, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(2);
        }
        super(element, textRange, icon, tooltipProvider, navHandler, alignment);
    }

    @Deprecated
    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, @Nullable Icon icon, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(3);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(4);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(5);
        }
        super(element, textRange, icon, tooltipProvider, navHandler, alignment);
    }

    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, @NotNull Icon icon, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment, @NotNull @NotNull Supplier<@NotNull @Nls String> accessibleNameProvider) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(6);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(7);
        }
        if (icon == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(8);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(9);
        }
        if (accessibleNameProvider == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(10);
        }
        super(element, textRange, icon, tooltipProvider, navHandler, alignment, accessibleNameProvider);
    }

    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, @NotNull Icon icon, @Nullable Function<? super T, String> tooltipProvider, @Nullable Function<? super PsiElement, @Nls(capitalization=Nls.Capitalization.Title) String> presentationProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment, @NotNull @NotNull Supplier<@NotNull @Nls String> accessibleNameProvider) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(11);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(12);
        }
        if (icon == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(13);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(14);
        }
        if (accessibleNameProvider == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(15);
        }
        super(element, textRange, icon, tooltipProvider, navHandler, alignment, accessibleNameProvider);
        this.myPresentationProvider = presentationProvider;
    }

    public abstract boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> var1);

    public int getWeight() {
        return 0;
    }

    public abstract Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> var1);

    @NotNull
    public static List<? extends MergeableLineMarkerInfo<?>> getMergedMarkers(LineMarkerInfo<?> info) {
        if (info instanceof MyLineMarkerInfo) {
            MyLineMarkerInfo myLineMarkerInfo = (MyLineMarkerInfo)info;
            List<? extends MergeableLineMarkerInfo<?>> list = myLineMarkerInfo.getInfos();
            if (list == null) {
                MergeableLineMarkerInfo.$$$reportNull$$$0(16);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(18);
        }
        Function function = element -> {
            LinkedHashSet tooltips = new LinkedHashSet(ContainerUtil.mapNotNull((Collection)infos, info -> info.getLineMarkerTooltip()));
            StringBuilder tooltip = new StringBuilder();
            for (String info2 : tooltips) {
                if (!tooltip.isEmpty()) {
                    tooltip.append("<hr size=1 noshade>");
                }
                tooltip.append(UIUtil.getHtmlBody((String)info2));
            }
            return XmlStringUtil.wrapInHtml((CharSequence)tooltip);
        };
        if (function == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(19);
        }
        return function;
    }

    @NotNull
    public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(20);
        }
        GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.LEFT;
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(21);
        }
        return alignment;
    }

    private static Supplier<@NotNull @Nls String> getCommonAccessibleNameProvider(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(22);
        }
        return infos.get(0).getAccessibleNameProvider();
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getElementPresentation(@NotNull PsiElement element) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(23);
        }
        String string = this.myPresentationProvider != null ? (String)this.myPresentationProvider.fun((Object)element) : element.getText();
        if (string == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static List<LineMarkerInfo<?>> merge(@NotNull List<? extends MergeableLineMarkerInfo<?>> sameLineMarkers, int passId) {
        if (sameLineMarkers == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(25);
        }
        ArrayList result = new ArrayList(sameLineMarkers.size());
        boolean[] alreadyMerged = new boolean[sameLineMarkers.size()];
        for (int i = 0; i < sameLineMarkers.size(); ++i) {
            MergeableLineMarkerInfo<?> prev = sameLineMarkers.get(i);
            if (alreadyMerged[i]) continue;
            SmartList toMerge = new SmartList();
            for (int k = i + 1; k < sameLineMarkers.size(); ++k) {
                MergeableLineMarkerInfo<?> next = sameLineMarkers.get(k);
                if (alreadyMerged[k]) continue;
                boolean canMergeWith = prev.canMergeWith(next);
                if (ApplicationManager.getApplication().isUnitTestMode() && !canMergeWith && next.canMergeWith(prev)) {
                    LOG.error("inconsistent canMergeWith():" + String.valueOf(next.getClass()) + "[" + next.getLineMarkerTooltip() + "] can merge " + String.valueOf(prev.getClass()) + "[" + prev.getLineMarkerTooltip() + "], but not vice versa");
                }
                if (!canMergeWith) continue;
                alreadyMerged[k] = true;
                if (toMerge.isEmpty()) {
                    toMerge.add(prev);
                }
                toMerge.add(next);
            }
            if (toMerge.isEmpty()) {
                result.add(prev);
                continue;
            }
            result.add(new MyLineMarkerInfo((List<? extends MergeableLineMarkerInfo<?>>)toMerge, passId));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    protected AnAction getNavigateAction() {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MouseEvent mouseEvent = 1.getMouseEvent(e);
                MergeableLineMarkerInfo.this.getNavigationHandler().navigate(mouseEvent, MergeableLineMarkerInfo.this.getElement());
            }

            @NotNull
            private static MouseEvent getMouseEvent(@NotNull AnActionEvent e) {
                InputEvent inputEvent;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((inputEvent = e.getInputEvent()) instanceof MouseEvent) {
                    MouseEvent mouseEvent;
                    MouseEvent mouseEvent2 = mouseEvent = (MouseEvent)inputEvent;
                    if (mouseEvent2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return mouseEvent2;
                }
                MouseEvent mouseEvent = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()).toMouseEvent();
                if (mouseEvent == null) {
                    1.$$$reportNull$$$0(3);
                }
                return mouseEvent;
            }

            public void update(@NotNull AnActionEvent e) {
                Object element;
                if (e == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((element = MergeableLineMarkerInfo.this.getElement()) != null) {
                    Presentation presentation = e.getPresentation();
                    presentation.setIcon(MergeableLineMarkerInfo.this.getIcon());
                    presentation.setText(MergeableLineMarkerInfo.this.getElementPresentation((PsiElement)element));
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(5);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMouseEvent";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getMouseEvent";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 5 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17, 19, 21, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessibleNameProvider";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameLineMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedMarkers";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTooltip";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonIconAlignment";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTooltip";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCommonIconAlignment";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAccessibleNameProvider";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementPresentation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 17, 19, 21, 24, 26 -> new IllegalStateException(string);
        };
    }

    private static final class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final List<? extends MergeableLineMarkerInfo<?>> myMarkers;
        private final List<ActionGroup> myGroups;

        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers, int passId) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(0);
            }
            this(markers, MyLineMarkerInfo.getTemplate(markers), passId);
        }

        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers, @NotNull MergeableLineMarkerInfo<?> template, int passId) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (template == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(2);
            }
            super(template.getElement(), MyLineMarkerInfo.getCommonTextRange(markers), template.getCommonIcon(markers), MergeableLineMarkerInfo.getCommonAccessibleNameProvider(markers), template.getCommonTooltip(markers), null, template.getCommonIconAlignment(markers));
            this.myMarkers = markers;
            this.myGroups = ContainerUtil.map(markers, info -> info.createGutterRenderer().getPopupMenuActions());
            this.updatePass = passId;
        }

        @NotNull
        public List<? extends MergeableLineMarkerInfo<?>> getInfos() {
            List<? extends MergeableLineMarkerInfo<?>> list = this.myMarkers;
            if (list == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        private DefaultActionGroup getCommonActionGroup() {
            DefaultActionGroup commonActionGroup = new DefaultActionGroup();
            for (int i = 0; i < this.myGroups.size(); ++i) {
                ActionGroup popupActions = this.myGroups.get(i);
                if (popupActions != null) {
                    commonActionGroup.addSeparator();
                    commonActionGroup.addAll(popupActions);
                    continue;
                }
                MergeableLineMarkerInfo<?> mergeableLineMarkerInfo = this.myMarkers.get(i);
                commonActionGroup.add(mergeableLineMarkerInfo.getNavigateAction());
            }
            DefaultActionGroup defaultActionGroup = commonActionGroup;
            if (defaultActionGroup == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(4);
            }
            return defaultActionGroup;
        }

        @NotNull
        private static TextRange getCommonTextRange(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(5);
            }
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo<?> marker : markers) {
                startOffset = Math.min(startOffset, marker.startOffset);
                endOffset = Math.max(endOffset, marker.endOffset);
            }
            TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
            if (textRange == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        @Override
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                @Override
                public AnAction getClickAction() {
                    return null;
                }

                @Override
                public boolean isNavigateAction() {
                    return true;
                }

                @NotNull
                public ActionGroup getPopupMenuActions() {
                    DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
                    if (defaultActionGroup == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return defaultActionGroup;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo$1", "getPopupMenuActions"));
                }
            };
        }

        private static MergeableLineMarkerInfo<?> getTemplate(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(7);
            }
            return Collections.max(markers, Comparator.comparingInt(MergeableLineMarkerInfo::getWeight));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfos";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonActionGroup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonTextRange";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6 -> new IllegalStateException(string);
            };
        }
    }
}

