/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/hints/HintInfo;", "", "<init>", "()V", "isOwnedByPsiElement", "", "elem", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "MethodInfo", "OptionInfo", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "intellij.platform.lang"})
public abstract sealed class HintInfo {
    private HintInfo() {
    }

    public boolean isOwnedByPsiElement(@NotNull PsiElement elem, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = elem.getTextRange();
        if (textRange == null) {
            return false;
        }
        int start = textRange.isEmpty() ? textRange.getStartOffset() : textRange.getStartOffset() + 1;
        return editor.getInlayModel().hasInlineElementsInRange(start, textRange.getEndOffset());
    }

    public /* synthetic */ HintInfo(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "Lcom/intellij/codeInsight/hints/HintInfo;", "fullyQualifiedName", "", "paramNames", "", "language", "Lcom/intellij/lang/Language;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/lang/Language;)V", "(Ljava/lang/String;Ljava/util/List;)V", "getFullyQualifiedName", "()Ljava/lang/String;", "getParamNames", "()Ljava/util/List;", "getLanguage", "()Lcom/intellij/lang/Language;", "getMethodName", "getDisableHintText", "intellij.platform.lang"})
    public static non-sealed class MethodInfo
    extends HintInfo {
        @NotNull
        private final String fullyQualifiedName;
        @NotNull
        private final List<String> paramNames;
        @Nullable
        private final Language language;

        public MethodInfo(@NotNull String fullyQualifiedName, @NotNull List<String> paramNames, @Nullable Language language) {
            Intrinsics.checkNotNullParameter((Object)fullyQualifiedName, (String)"fullyQualifiedName");
            Intrinsics.checkNotNullParameter(paramNames, (String)"paramNames");
            super(null);
            this.fullyQualifiedName = fullyQualifiedName;
            this.paramNames = paramNames;
            this.language = language;
        }

        @NotNull
        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @NotNull
        public final List<String> getParamNames() {
            return this.paramNames;
        }

        @Nullable
        public final Language getLanguage() {
            return this.language;
        }

        public MethodInfo(@NotNull String fullyQualifiedName, @NotNull List<String> paramNames) {
            Intrinsics.checkNotNullParameter((Object)fullyQualifiedName, (String)"fullyQualifiedName");
            Intrinsics.checkNotNullParameter(paramNames, (String)"paramNames");
            this(fullyQualifiedName, paramNames, null);
        }

        @NotNull
        public String getMethodName() {
            int start = StringsKt.lastIndexOf$default((CharSequence)this.fullyQualifiedName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            String string = this.fullyQualifiedName.substring(start);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        @NlsActions.ActionText
        @NotNull
        public String getDisableHintText() {
            Object[] objectArray = new Object[]{this.getMethodName()};
            String string = CodeInsightBundle.message("inlay.hints.show.settings", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "Lcom/intellij/codeInsight/hints/HintInfo;", "option", "Lcom/intellij/codeInsight/hints/Option;", "<init>", "(Lcom/intellij/codeInsight/hints/Option;)V", "getOption", "()Lcom/intellij/codeInsight/hints/Option;", "disable", "", "enable", "alternate", "optionName", "", "getOptionName", "()Ljava/lang/String;", "isOptionEnabled", "", "intellij.platform.lang"})
    public static non-sealed class OptionInfo
    extends HintInfo {
        @NotNull
        private final Option option;
        @NotNull
        private final String optionName;

        public OptionInfo(@NotNull Option option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            super(null);
            this.option = option;
            this.optionName = this.option.getName();
        }

        @NotNull
        protected final Option getOption() {
            return this.option;
        }

        public void disable() {
            this.alternate();
        }

        public void enable() {
            this.alternate();
        }

        private final void alternate() {
            boolean current = this.option.get();
            this.option.set(!current);
        }

        @NotNull
        public String getOptionName() {
            return this.optionName;
        }

        public final boolean isOptionEnabled() {
            return this.option.isEnabled();
        }
    }
}

