/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.content.Content;
import java.util.ArrayList;

public interface CellTransform {

    public static interface Facade {
        public void minimize(Content var1, Restore var2);
    }

    public static interface Restore {
        public ActionCallback restoreInGrid();

        public static class List
        implements Restore {
            private final ArrayList<Restore> myActions = new ArrayList();
            private boolean myRestoringNow;

            public void add(Restore restore) {
                this.myActions.add(restore);
            }

            @Override
            public ActionCallback restoreInGrid() {
                this.myRestoringNow = true;
                if (this.myActions.isEmpty()) {
                    return ActionCallback.DONE;
                }
                ActionCallback topCallback = this.restore(0);
                return topCallback.doWhenDone(() -> {
                    this.myActions.clear();
                    this.myRestoringNow = false;
                });
            }

            private ActionCallback restore(int index) {
                ActionCallback result = new ActionCallback();
                Restore action = this.myActions.get(index);
                ActionCallback actionCalback = action.restoreInGrid();
                actionCalback.doWhenDone(() -> {
                    if (index < this.myActions.size() - 1) {
                        this.restore(index + 1).notifyWhenDone(result);
                    } else {
                        result.setDone();
                    }
                });
                return result;
            }

            public boolean isRestoringNow() {
                return this.myRestoringNow;
            }
        }
    }
}

