/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.http;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeWithMe.ClientId;
import com.intellij.microservices.HttpReferenceService;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.http.HttpHeaderReferenceKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000eB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/http/HttpHeaderReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getUnresolvedMessagePattern", "", "resolve", "isReferenceTo", "", "Companion", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nHttpHeaderReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpHeaderReference.kt\ncom/intellij/microservices/http/HttpHeaderReference\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,43:1\n42#2,3:44\n42#2,3:47\n*S KotlinDebug\n*F\n+ 1 HttpHeaderReference.kt\ncom/intellij/microservices/http/HttpHeaderReference\n*L\n25#1:44,3\n29#1:47,3\n*E\n"})
public final class HttpHeaderReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public HttpHeaderReference(@NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(element, range);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return MicroservicesBundle.message("http.header.element.error", new Object[0]);
    }

    @Nullable
    public PsiElement resolve() {
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String value = string;
        if (!HttpHeaderReferenceKt.access$getHEADER_NAME_PATTERN$p().matcher(value).matches()) {
            return null;
        }
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        HttpReferenceService httpReferenceService = (HttpReferenceService)object;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return httpReferenceService.resolveHeaderReference(psiElement, value);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        HttpReferenceService httpReferenceService = (HttpReferenceService)object;
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return httpReferenceService.isReferenceToHeaderElement(element, string);
    }

    @JvmStatic
    @NotNull
    public static final PsiReference[] forElement(@NotNull PsiElement injectionHost) {
        return Companion.forElement(injectionHost);
    }

    @JvmStatic
    @NotNull
    public static final PsiReference[] forElement(@NotNull PsiElement injectionHost, @NotNull TextRange range) {
        return Companion.forElement(injectionHost, range);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\tJ#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/microservices/http/HttpHeaderReference$Companion;", "", "<init>", "()V", "forElement", "", "Lcom/intellij/psi/PsiReference;", "injectionHost", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)[Lcom/intellij/psi/PsiReference;", "intellij.platform.lang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PsiReference[] forElement(@NotNull PsiElement injectionHost) {
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)injectionHost);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
            return this.forElement(injectionHost, textRange);
        }

        @JvmStatic
        @NotNull
        public final PsiReference[] forElement(@NotNull PsiElement injectionHost, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            PsiReference[] psiReferenceArray = new PsiReference[]{new HttpHeaderReference(injectionHost, range)};
            return psiReferenceArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

