/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.parameters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.microservices.HttpReferenceService;
import com.intellij.microservices.url.parameters.PathVariableUsagesProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolvingHint;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public final class PathVariableDeclaringReference
extends PsiReferenceBase<PsiElement>
implements ResolvingHint {
    private final PathVariableUsagesProvider myVariableUsagesProvider;

    public PathVariableDeclaringReference(@NotNull PsiElement host, @NotNull TextRange range, PathVariableUsagesProvider variableUsagesProvider) {
        if (host == null) {
            PathVariableDeclaringReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PathVariableDeclaringReference.$$$reportNull$$$0(1);
        }
        super(host, range, false);
        this.myVariableUsagesProvider = variableUsagesProvider;
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = ContainerUtil.collect(this.myVariableUsagesProvider.getCompletionVariantsForDeclaration(this.getElement()).iterator()).toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            PathVariableDeclaringReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public String toString() {
        return "PathVariableReference(" + this.getValue() + ", " + String.valueOf(this.getRangeInElement()) + ")";
    }

    public PomTargetPsiElement resolve() {
        HttpReferenceService service = (HttpReferenceService)ApplicationManager.getApplication().getService(HttpReferenceService.class);
        return service.resolvePathVariableDeclaration(this.getValue(), this.getElement(), this.getRangeInElement(), this.myVariableUsagesProvider);
    }

    public boolean canResolveTo(@NotNull Class<? extends PsiElement> elementClass) {
        if (elementClass == null) {
            PathVariableDeclaringReference.$$$reportNull$$$0(3);
        }
        HttpReferenceService service = (HttpReferenceService)ApplicationManager.getApplication().getService(HttpReferenceService.class);
        return service.canResolveToPathVariableDeclaration(elementClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/url/parameters/PathVariableDeclaringReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/url/parameters/PathVariableDeclaringReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canResolveTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

