/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.NlsContexts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringMessageDialog
extends DialogWrapper {
    private final @NlsContexts.DialogMessage String myMessage;
    private final String myHelpTopic;
    private final Icon myIcon;
    private final boolean myIsCancelButtonVisible;

    public RefactoringMessageDialog(@NlsContexts.DialogTitle String title, @NlsContexts.DialogMessage String message, @NonNls String helpTopic, @NonNls String iconId, boolean showCancelButton, Project project) {
        super(project, false);
        this.setTitle(title);
        this.myMessage = message;
        this.myHelpTopic = helpTopic;
        this.myIsCancelButtonVisible = showCancelButton;
        this.myIcon = UIManager.getIcon(iconId);
        this.init();
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        if (this.myIsCancelButtonVisible) {
            actions.add(this.getCancelAction());
        }
        if (this.myHelpTopic != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            RefactoringMessageDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected JComponent createNorthPanel() {
        JLabel label = new JLabel(this.myMessage);
        label.setUI((LabelUI)new MultiLineLabelUI());
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        if (this.myIcon != null) {
            panel.add((Component)new JLabel(this.myIcon), "West");
            panel.add((Component)label, "Center");
        } else {
            panel.add((Component)label, "West");
        }
        return panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpTopic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/RefactoringMessageDialog", "createActions"));
    }
}

