package com.intellij.microservices.http

import com.intellij.microservices.MicroservicesBundle
import org.jetbrains.annotations.Nls

enum class HttpCode(val statusCode: Int, @Nls val shortDescription: String) {
  SWITCHING_PROTOCOLS(101, MicroservicesBundle.message("http.code.description.101")),
  PROCESSING(102, MicroservicesBundle.message("http.code.description.102")),
  OK(200, MicroservicesBundle.message("http.code.description.200")),
  CREATED(201, MicroservicesBundle.message("http.code.description.201")),
  ACCEPTED(202, MicroservicesBundle.message("http.code.description.202")),
  NON_AUTHORITATIVE_INFORMATION(203, MicroservicesBundle.message("http.code.description.203")),
  NO_CONTENT(204, MicroservicesBundle.message("http.code.description.204")),
  RESET_CONTENT(205, MicroservicesBundle.message("http.code.description.205")),
  PARTIAL_CONTENT(206, MicroservicesBundle.message("http.code.description.206")),
  MULTI_STATUS(207, MicroservicesBundle.message("http.code.description.207")),
  MULTIPLE_CHOICES(300, MicroservicesBundle.message("http.code.description.300")),
  MOVED_PERMANENTLY(301, MicroservicesBundle.message("http.code.description.301")),
  FOUND(302, MicroservicesBundle.message("http.code.description.302")),
  SEE_OTHER(303, MicroservicesBundle.message("http.code.description.303")),
  NOT_MODIFIED(304, MicroservicesBundle.message("http.code.description.304")),
  USE_PROXY(305, MicroservicesBundle.message("http.code.description.305")),
  TEMPORARY_REDIRECT(307, MicroservicesBundle.message("http.code.description.307")),
  PERMANENT_REDIRECT(308, MicroservicesBundle.message("http.code.description.308")),
  BAD_REQUEST(400, MicroservicesBundle.message("http.code.description.400")),
  UNAUTHORIZED(401, MicroservicesBundle.message("http.code.description.401")),
  PAYMENT_REQUIRED(402, MicroservicesBundle.message("http.code.description.402")),
  FORBIDDEN(403, MicroservicesBundle.message("http.code.description.403")),
  NOT_FOUND(404, MicroservicesBundle.message("http.code.description.404")),
  METHOD_NOT_ALLOWED(405, MicroservicesBundle.message("http.code.description.405")),
  NOT_ACCEPTABLE(406, MicroservicesBundle.message("http.code.description.406")),
  PROXY_AUTHENTICATION_REQUIRED(407, MicroservicesBundle.message("http.code.description.407")),
  REQUEST_TIMEOUT(408, MicroservicesBundle.message("http.code.description.408")),
  CONFLICT(409, MicroservicesBundle.message("http.code.description.409")),
  GONE(410, MicroservicesBundle.message("http.code.description.410")),
  LENGTH_REQUIRED(411, MicroservicesBundle.message("http.code.description.411")),
  PRECONDITION_FAILED(412, MicroservicesBundle.message("http.code.description.412")),
  REQUEST_ENTITY_TOO_LARGE(413, MicroservicesBundle.message("http.code.description.413")),
  REQUEST_URI_TOO_LONG(414, MicroservicesBundle.message("http.code.description.414")),
  UNSUPPORTED_MEDIA_TYPE(415, MicroservicesBundle.message("http.code.description.415")),
  REQUESTED_RANGE_NOT_SATISFIABLE(416, MicroservicesBundle.message("http.code.description.416")),
  EXPECTATION_FAILED(417, MicroservicesBundle.message("http.code.description.417")),
  MISDIRECTED_REQUEST(421, MicroservicesBundle.message("http.code.description.421")),
  UNPROCESSABLE_ENTITY(422, MicroservicesBundle.message("http.code.description.422")),
  LOCKED(423, MicroservicesBundle.message("http.code.description.423")),
  FAILED_DEPENDENCY(424, MicroservicesBundle.message("http.code.description.424")),
  UNORDERED_COLLECTION(425, MicroservicesBundle.message("http.code.description.425")),
  UPGRADE_REQUIRED(426, MicroservicesBundle.message("http.code.description.426")),
  PRECONDITION_REQUIRED(428, MicroservicesBundle.message("http.code.description.428")),
  TOO_MANY_REQUESTS(429, MicroservicesBundle.message("http.code.description.429")),
  REQUEST_HEADER_FIELDS_TOO_LARGE(431, MicroservicesBundle.message("http.code.description.431")),
  INTERNAL_SERVER_ERROR(500, MicroservicesBundle.message("http.code.description.500")),
  NOT_IMPLEMENTED(501, MicroservicesBundle.message("http.code.description.501")),
  BAD_GATEWAY(502, MicroservicesBundle.message("http.code.description.502")),
  SERVICE_UNAVAILABLE(503, MicroservicesBundle.message("http.code.description.503")),
  GATEWAY_TIMEOUT(504, MicroservicesBundle.message("http.code.description.504")),
  HTTP_VERSION_NOT_SUPPORTED(505, MicroservicesBundle.message("http.code.description.505")),
  VARIANT_ALSO_NEGOTIATES(506, MicroservicesBundle.message("http.code.description.506")),
  INSUFFICIENT_STORAGE(507, MicroservicesBundle.message("http.code.description.507")),
  NOT_EXTENDED(510, MicroservicesBundle.message("http.code.description.510")),
  NETWORK_AUTHENTICATION_REQUIRED(511, MicroservicesBundle.message("http.code.description.511")),
}