/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.MultipleRunLocationsProvider;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationFromContextWrapper;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class PreferredProducerFind {
    private static final Logger LOG = Logger.getInstance(PreferredProducerFind.class);

    private PreferredProducerFind() {
    }

    @Nullable
    public static RunnerAndConfigurationSettings createConfiguration(@NotNull Location location, @NotNull ConfigurationContext context) {
        List<ConfigurationFromContext> configsFromContext;
        if (location == null) {
            PreferredProducerFind.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PreferredProducerFind.$$$reportNull$$$0(1);
        }
        ConfigurationFromContext fromContext = !ContainerUtil.isEmpty(configsFromContext = PreferredProducerFind.getConfigurationsFromContext(location, context, true, true)) ? configsFromContext.get(0) : null;
        return fromContext != null ? fromContext.getConfigurationSettings() : null;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static List<RuntimeConfigurationProducer> findPreferredProducers(Location location, ConfigurationContext context, boolean strict) {
        if (location == null) {
            return null;
        }
        List<RuntimeConfigurationProducer> producers = PreferredProducerFind.findAllProducers(location, context);
        if (producers.isEmpty()) {
            return null;
        }
        producers.sort(RuntimeConfigurationProducer.COMPARATOR);
        if (strict) {
            RuntimeConfigurationProducer first = producers.get(0);
            Iterator<RuntimeConfigurationProducer> it = producers.iterator();
            while (it.hasNext()) {
                RuntimeConfigurationProducer producer = it.next();
                if (producer == first || RuntimeConfigurationProducer.COMPARATOR.compare(producer, first) < 0) continue;
                it.remove();
            }
        }
        return producers;
    }

    private static List<RuntimeConfigurationProducer> findAllProducers(Location location, ConfigurationContext context) {
        ArrayList<RuntimeConfigurationProducer> result = new ArrayList<RuntimeConfigurationProducer>();
        List producers = RuntimeConfigurationProducer.RUNTIME_CONFIGURATION_PRODUCER.getExtensionList();
        for (RuntimeConfigurationProducer prototype : DumbService.getInstance((Project)context.getProject()).filterByDumbAwareness((Collection)producers)) {
            RuntimeConfigurationProducer producer;
            try {
                producer = prototype.createProducer(location, context);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error((Throwable)PluginException.createByClass((Throwable)e, prototype.getClass()));
                continue;
            }
            if (producer.getConfiguration() == null) continue;
            LOG.assertTrue(producer.getSourceElement() != null, (Object)producer);
            result.add(producer);
        }
        return result;
    }

    public static @Unmodifiable @Nullable List<ConfigurationFromContext> getConfigurationsFromContext(Location location, @NotNull ConfigurationContext context, boolean strict, boolean preferExisting) {
        if (context == null) {
            PreferredProducerFind.$$$reportNull$$$0(2);
        }
        if (location == null) {
            return null;
        }
        MultipleRunLocationsProvider.AlternativeLocationsInfo alternativeLocations = MultipleRunLocationsProvider.findAlternativeLocations(location);
        if (alternativeLocations == null) {
            return PreferredProducerFind.doGetConfigurationsFromContext(location, context, strict, preferExisting);
        }
        return PreferredProducerFind.getConfigurationsFromAlternativeLocations(alternativeLocations, location, strict, preferExisting);
    }

    @Nullable
    private static List<ConfigurationFromContext> doGetConfigurationsFromContext(@NotNull Location location, @NotNull ConfigurationContext context, boolean strict, boolean preferExisting) {
        if (location == null) {
            PreferredProducerFind.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PreferredProducerFind.$$$reportNull$$$0(4);
        }
        ArrayList<ConfigurationFromContext> configurationsFromContext = new ArrayList<ConfigurationFromContext>();
        for (RuntimeConfigurationProducer runtimeConfigurationProducer : PreferredProducerFind.findAllProducers(location, context)) {
            configurationsFromContext.add(new ConfigurationFromContextWrapper(runtimeConfigurationProducer));
        }
        for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(context.getProject())) {
            ProgressManager.checkCanceled();
            ConfigurationFromContext fromContext = preferExisting ? runConfigurationProducer.findOrCreateConfigurationFromContext(context) : runConfigurationProducer.createConfigurationFromContext(context);
            if (fromContext == null) continue;
            configurationsFromContext.add(fromContext);
        }
        if (configurationsFromContext.isEmpty()) {
            return null;
        }
        configurationsFromContext.sort(ConfigurationFromContext.COMPARATOR);
        if (strict) {
            ConfigurationFromContext first = configurationsFromContext.get(0);
            Iterator<ConfigurationFromContext> iterator = configurationsFromContext.iterator();
            while (iterator.hasNext()) {
                ConfigurationFromContext producer = iterator.next();
                if (producer == first || ConfigurationFromContext.COMPARATOR.compare(producer, first) <= 0) continue;
                iterator.remove();
            }
        }
        return configurationsFromContext;
    }

    private static @Unmodifiable @Nullable List<ConfigurationFromContext> getConfigurationsFromAlternativeLocations(@NotNull MultipleRunLocationsProvider.AlternativeLocationsInfo alternativeLocationsInfo, @NotNull Location originalLocation, boolean strict, boolean preferExisting) {
        if (alternativeLocationsInfo == null) {
            PreferredProducerFind.$$$reportNull$$$0(5);
        }
        if (originalLocation == null) {
            PreferredProducerFind.$$$reportNull$$$0(6);
        }
        SmartList result = new SmartList();
        for (Location<?> alternativeLocation : alternativeLocationsInfo.getAlternativeLocations()) {
            ConfigurationContext fakeContextForAlternativeLocation;
            List<ConfigurationFromContext> configurationsForLocation = PreferredProducerFind.doGetConfigurationsFromContext(alternativeLocation, fakeContextForAlternativeLocation = ConfigurationContext.createEmptyContextForLocation(alternativeLocation), strict, preferExisting);
            if (configurationsForLocation == null) continue;
            for (ConfigurationFromContext configurationFromContext : configurationsForLocation) {
                configurationFromContext.setFromAlternativeLocation(true);
                String locationDisplayName = alternativeLocationsInfo.getProvider().getLocationDisplayName(alternativeLocation, originalLocation);
                configurationFromContext.setAlternativeLocationDisplayName(locationDisplayName);
                RunConfiguration configuration = configurationFromContext.getConfiguration();
                if (!(configuration instanceof LocatableConfigurationBase) || !((LocatableConfiguration)configuration).isGeneratedName()) continue;
                configuration.setName(configuration.getName() + " " + locationDisplayName);
                ((LocatableConfigurationBase)configuration).setNameChangedByUser(true);
            }
            result.addAll(configurationsForLocation);
        }
        return (List)ContainerUtil.nullize((Collection)result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alternativeLocationsInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalLocation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/actions/PreferredProducerFind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurationsFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetConfigurationsFromContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurationsFromAlternativeLocations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

