/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.http;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.HttpReferenceService;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/http/HttpMethodReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "resolve", "getUnresolvedMessagePattern", "", "isReferenceTo", "", "getVariants", "", "", "()[Ljava/lang/Object;", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nHttpMethodReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpMethodReference.kt\ncom/intellij/microservices/http/HttpMethodReference\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n42#2,3:39\n42#2,3:42\n1563#3:45\n1634#3,3:46\n*S KotlinDebug\n*F\n+ 1 HttpMethodReference.kt\ncom/intellij/microservices/http/HttpMethodReference\n*L\n22#1:39,3\n30#1:42,3\n34#1:45\n34#1:46,3\n*E\n"})
public final class HttpMethodReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    public HttpMethodReference(@NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(element, range);
    }

    @Nullable
    public PsiElement resolve() {
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String value = string;
        if (StringsKt.isBlank((CharSequence)value)) {
            return null;
        }
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        HttpReferenceService httpReferenceService = (HttpReferenceService)object;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        TextRange textRange = this.getRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
        return httpReferenceService.resolveHttpMethod(psiElement, value, textRange);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return MicroservicesBundle.message("http.method.element.error", new Object[0]);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        HttpReferenceService httpReferenceService = (HttpReferenceService)object;
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return httpReferenceService.isReferenceToHttpMethod(element, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = UrlConstants.HTTP_METHODS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LookupElementBuilder.create((String)it).withIcon(AllIcons.Nodes.PpWeb));
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toObjectArray(...)");
        return objectArray;
    }
}

