/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.utils.doc.impl;

import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HtmlBlockMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\"\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00150\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/markdown/utils/doc/impl/DocHtmlBlockProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "<init>", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "", "OPEN_CLOSE_REGEXES", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "FIND_START_REGEX", "intellij.platform.markdown.utils"})
@SourceDebugExtension(value={"SMAP\nDocHtmlBlockProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocHtmlBlockProvider.kt\ncom/intellij/markdown/utils/doc/impl/DocHtmlBlockProvider\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n*L\n1#1,69:1\n107#2,4:70\n107#2,4:74\n*S KotlinDebug\n*F\n+ 1 DocHtmlBlockProvider.kt\ncom/intellij/markdown/utils/doc/impl/DocHtmlBlockProvider\n*L\n41#1:70,4\n47#1:74,4\n*E\n"})
public final class DocHtmlBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final DocHtmlBlockProvider INSTANCE = new DocHtmlBlockProvider();
    @NotNull
    private static final List<Pair<Regex, Regex>> OPEN_CLOSE_REGEXES;
    @NotNull
    private static final Regex FIND_START_REGEX;

    private DocHtmlBlockProvider() {
    }

    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        int matchingGroup = this.matches(pos, stateInfo.getCurrentConstraints());
        boolean bl = 0 <= matchingGroup ? matchingGroup < 4 : false;
        if (bl) {
            return CollectionsKt.listOf((Object)new HtmlBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (Regex)OPEN_CLOSE_REGEXES.get(matchingGroup).getSecond(), pos));
        }
        return CollectionsKt.emptyList();
    }

    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int n = this.matches(pos, constraints);
        return 0 <= n ? n < 5 : false;
    }

    private final int matches(LookaheadText.Position pos, MarkdownConstraints constraints) {
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return -1;
        }
        CharSequence text = pos.getCurrentLineFromPosition();
        int offset = MarkerBlockProvider.Companion.passSmallIndent$default((MarkerBlockProvider.Companion)MarkerBlockProvider.Companion, (CharSequence)text, (int)0, (int)2, null);
        if (offset >= text.length() || text.charAt(offset) != '<') {
            return -1;
        }
        CharSequence charSequence = text;
        int n = charSequence.length();
        MatchResult matchResult = Regex.find$default((Regex)FIND_START_REGEX, (CharSequence)((Object)charSequence.subSequence(offset, n)).toString(), (int)0, (int)2, null);
        if (matchResult == null) {
            return -1;
        }
        MatchResult matchResult2 = matchResult;
        Compat compat = Compat.INSTANCE;
        int condition$iv = matchResult2.getGroups().size() == OPEN_CLOSE_REGEXES.size() + 2 ? 1 : 0;
        boolean $i$f$assert = false;
        if (condition$iv == 0) {
            boolean bl = false;
            String string = "There are some excess capturing groups probably!";
            throw new MarkdownParsingException(string);
        }
        condition$iv = ((Collection)OPEN_CLOSE_REGEXES).size();
        for (int i = 0; i < condition$iv; ++i) {
            if (matchResult2.getGroups().get(i + 2) == null) continue;
            return i;
        }
        Compat i = Compat.INSTANCE;
        condition$iv = 0;
        $i$f$assert = false;
        boolean bl = false;
        String string = "Match found but all groups are empty!";
        throw new MarkdownParsingException(string);
    }

    private static final CharSequence FIND_START_REGEX$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "(" + ((Regex)it.getFirst()).getPattern() + ")";
    }

    static {
        Object[] objectArray = new Pair[]{new Pair((Object)new Regex("<(?:script|pre|style)(?: |>|$)", RegexOption.IGNORE_CASE), (Object)new Regex("</(?:script|style|pre)>", RegexOption.IGNORE_CASE)), new Pair((Object)new Regex("<!--"), (Object)new Regex("-->")), new Pair((Object)new Regex("<\\?"), (Object)new Regex("\\?>")), new Pair((Object)new Regex("<![A-Z]"), (Object)new Regex(">")), new Pair((Object)new Regex("<!\\[CDATA\\["), (Object)new Regex("]]>")), new Pair((Object)new Regex("</?(?:" + CollectionsKt.joinToString$default((Iterable)DocMarkdownToHtmlConverter.INSTANCE.getACCEPTABLE_BLOCK_TAGS$intellij_platform_markdown_utils(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")(?: |/?>|$)", RegexOption.IGNORE_CASE), null)};
        OPEN_CLOSE_REGEXES = CollectionsKt.listOf((Object[])objectArray);
        FIND_START_REGEX = new Regex("^(" + CollectionsKt.joinToString$default((Iterable)OPEN_CLOSE_REGEXES, (CharSequence)"|", null, null, (int)0, null, DocHtmlBlockProvider::FIND_START_REGEX$lambda$0, (int)30, null) + ")");
    }
}

