// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.platform.ml.impl.turboComplete

import com.intellij.codeInsight.completion.CompletionParameters
import com.intellij.codeInsight.completion.CompletionResultSet
import org.jetbrains.annotations.ApiStatus

/**
 * Collects all [SuggestionGenerator] of the same variety,
 * without executing them.
 *
 * The purpose of this class it to just acknowledge existence of
 * the generators, so then we can reorder the generators, and
 * run them in the order we want.
 */
@ApiStatus.Internal
interface KindCollector {
  /**
   * The variety of completion suggestions generated by collected [SuggestionGenerator]s
   *
   * An analogue of [com.intellij.codeInsight.completion.CompletionContributor],
   * but instead of executing all suggestion generators immediately, it delegates their execution
   */
  val kindVariety: KindVariety

  /**
   * Checks if this collector is relevant within the given parameters
   */
  fun shouldBeCalled(parameters: CompletionParameters): Boolean

  /**
   * Collects and adds [SuggestionGenerator]s to the consumer
   *
   * An analogue of [com.intellij.codeInsight.completion.CompletionContributor.fillCompletionVariants]
   *
   * @param parameters The completion parameters containing information about the current completion request.
   * @param generatorExecutor The suggestion generator consumer used to collect [SuggestionGenerator]s.
   * @param result The completion result set to which the suggestions will be added.
   */
  fun collectKinds(parameters: CompletionParameters,
                   generatorExecutor: SuggestionGeneratorExecutor,
                   result: CompletionResultSet)
}