// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.platform.navbar.frontend.vm

import com.intellij.platform.navbar.NavBarItemPresentationData
import kotlinx.coroutines.flow.StateFlow

interface NavBarItemVm {

  val presentation: NavBarItemPresentationData

  val isFirst: Boolean

  val isLast: Boolean

  val selected: StateFlow<Boolean>

  fun isNextSelected(): Boolean

  fun isInactive(): Boolean

  fun select()

  fun showPopup()

  fun activate()
}
