/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.serialization.ObjectSerializer;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadConfiguration;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.VersionedFileKt;
import com.intellij.serialization.WriteConfiguration;
import com.intellij.util.ParameterizedTypeImpl;
import com.intellij.util.io.LZ4Compressor;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import net.jpountz.xxhash.XXHashFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ4\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007J8\u0010\u0017\u001a\n\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u0018\"\u0004\b\u0000\u0010\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0007H\u0007JT\u0010\u001b\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00142+\b\u0002\u0010\u001d\u001a%\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001ej\u0004\u0018\u0001`\"H\u0007\u00a2\u0006\u0002\u0010#JE\u0010$\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00142\u0006\u0010\u0015\u001a\u00020\u00192\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010\u001a\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u000fH\u0002J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c2\u0003J'\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00072\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\u0005H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/serialization/VersionedFile;", "", "file", "Ljava/nio/file/Path;", "version", "", "isCompressed", "", "<init>", "(Ljava/nio/file/Path;IZ)V", "getFile", "()Ljava/nio/file/Path;", "getVersion", "()I", "writeList", "", "T", "data", "", "itemClass", "Ljava/lang/Class;", "configuration", "Lcom/intellij/serialization/WriteConfiguration;", "readList", "", "Lcom/intellij/serialization/ReadConfiguration;", "renameToCorruptedOnError", "read", "objectClass", "beanConstructed", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "instance", "Lcom/intellij/serialization/BeanConstructed;", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readAndHandleErrors", "originalType", "Ljava/lang/reflect/Type;", "(Ljava/lang/Class;Lcom/intellij/serialization/ReadConfiguration;Ljava/lang/reflect/Type;Z)Ljava/lang/Object;", "renameSilentlyToCorrupted", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "intellij.platform.objectSerializer"})
@SourceDebugExtension(value={"SMAP\nVersionedFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionedFile.kt\ncom/intellij/serialization/VersionedFile\n+ 2 VersionedFile.kt\ncom/intellij/serialization/VersionedFileKt\n*L\n1#1,127:1\n105#2,21:128\n*S KotlinDebug\n*F\n+ 1 VersionedFile.kt\ncom/intellij/serialization/VersionedFile\n*L\n73#1:128,21\n*E\n"})
public final class VersionedFile {
    @NotNull
    private final Path file;
    private final int version;
    private final boolean isCompressed;

    @JvmOverloads
    public VersionedFile(@NotNull Path file, int version, boolean isCompressed) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.version = version;
        this.isCompressed = isCompressed;
    }

    public /* synthetic */ VersionedFile(Path path, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(path, n, bl);
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    public final int getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final <T> void writeList(@NotNull Collection<? extends T> data, @NotNull Class<T> itemClass, @NotNull WriteConfiguration configuration) throws IOException {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Closeable closeable = PathKt.safeOutputStream((Path)this.file);
        Throwable throwable = null;
        try {
            OutputStream outputStream;
            Object[] objectArray;
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            if (this.isCompressed) {
                objectArray = new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE};
                outputStream = (OutputStream)new LZ4FrameOutputStream(it, LZ4FrameOutputStream.BLOCKSIZE.SIZE_4MB, -1L, (net.jpountz.lz4.LZ4Compressor)LZ4Compressor.INSTANCE, XXHashFactory.fastestJavaInstance().hash32(), objectArray);
            } else {
                outputStream = it;
            }
            OutputStream out = outputStream;
            objectArray = new Type[]{itemClass};
            ObjectSerializer.Companion.getInstance().getSerializer$intellij_platform_objectSerializer().writeVersioned(data, out, this.version, configuration, (Type)new ParameterizedTypeImpl((Type)data.getClass(), (Type[])objectArray));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeList$default(VersionedFile versionedFile, Collection collection, Class clazz, WriteConfiguration writeConfiguration, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            writeConfiguration = VersionedFileKt.access$getVersionedFileDefaultWriteConfiguration$p();
        }
        versionedFile.writeList(collection, clazz, writeConfiguration);
    }

    @JvmOverloads
    @Nullable
    public final <T> List<T> readList(@NotNull Class<T> itemClass, @NotNull ReadConfiguration configuration, boolean renameToCorruptedOnError) throws IOException, SerializationException {
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Type[] typeArray = new Type[]{itemClass};
        return this.readAndHandleErrors(ArrayList.class, configuration, (Type)new ParameterizedTypeImpl((Type)((Object)ArrayList.class), typeArray), renameToCorruptedOnError);
    }

    public static /* synthetic */ List readList$default(VersionedFile versionedFile, Class clazz, ReadConfiguration readConfiguration, boolean bl, int n, Object object) throws IOException, SerializationException {
        if ((n & 2) != 0) {
            readConfiguration = new ReadConfiguration(false, null, null, null, 15, null);
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return versionedFile.readList(clazz, readConfiguration, bl);
    }

    @JvmOverloads
    @Nullable
    public final <T> T read(@NotNull Class<T> objectClass, @Nullable Function1<Object, ? extends Object> beanConstructed) throws IOException, SerializationException {
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        return (T)VersionedFile.readAndHandleErrors$default(this, objectClass, new ReadConfiguration(false, null, beanConstructed, null, 11, null), null, false, 12, null);
    }

    public static /* synthetic */ Object read$default(VersionedFile versionedFile, Class clazz, Function1 function1, int n, Object object) throws IOException, SerializationException {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return versionedFile.read(clazz, (Function1<Object, ? extends Object>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T readAndHandleErrors(Class<T> objectClass, ReadConfiguration configuration, Type originalType, boolean renameToCorruptedOnError) {
        Object v0;
        block16: {
            Closeable closeable;
            Path file$iv = this.file;
            boolean $i$f$readPossiblyCompressedIonFile = false;
            try {
                closeable = Files.newByteChannel(file$iv, SetsKt.setOf((Object)StandardOpenOption.READ), new FileAttribute[0]);
            }
            catch (NoSuchFileException e$iv) {
                v0 = null;
                break block16;
            }
            catch (IOException e$iv) {
                ObjectSerializerKt.getLOG().error((Throwable)e$iv);
                v0 = null;
                break block16;
            }
            SeekableByteChannel channel$iv = closeable;
            closeable = channel$iv;
            Throwable throwable = null;
            try {
                T t;
                FilterInputStream filterInputStream;
                Closeable it$iv = closeable;
                boolean bl = false;
                ByteBuffer lz4Magic$iv = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
                channel$iv.read(lz4Magic$iv);
                channel$iv.position(0L);
                InputStream input$iv = Channels.newInputStream(channel$iv);
                if (lz4Magic$iv.getInt(0) == 407708164) {
                    filterInputStream = (FilterInputStream)new LZ4FrameInputStream(input$iv, LZ4Factory.fastestJavaInstance().safeDecompressor(), XXHashFactory.fastestJavaInstance().hash32());
                } else {
                    InputStream inputStream = input$iv;
                    Intrinsics.checkNotNull((Object)inputStream);
                    int n = 32768;
                    filterInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
                }
                InputStream input = input$iv = (InputStream)filterInputStream;
                boolean bl2 = false;
                try {
                    t = ObjectSerializer.Companion.getInstance().getSerializer$intellij_platform_objectSerializer().readVersioned(objectClass, input, this.file, this.version, configuration, originalType);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (renameToCorruptedOnError) {
                        this.renameSilentlyToCorrupted();
                    }
                    ObjectSerializerKt.getLOG().error((Throwable)e);
                    T t2 = null;
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    return t2;
                }
                T result = t;
                if (result == null && renameToCorruptedOnError) {
                    this.renameSilentlyToCorrupted();
                }
                T t3 = result;
                return t3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return v0;
    }

    static /* synthetic */ Object readAndHandleErrors$default(VersionedFile versionedFile, Class clazz, ReadConfiguration readConfiguration, Type type, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            type = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return versionedFile.readAndHandleErrors(clazz, readConfiguration, type, bl);
    }

    private final void renameSilentlyToCorrupted() {
        try {
            Path path = this.file.getParent().resolve(this.file.getFileName() + ".corrupted");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            PathKt.move((Path)this.file, (Path)path);
        }
        catch (Exception e) {
            ObjectSerializerKt.getLOG().debug((Throwable)e);
        }
    }

    @NotNull
    public final Path component1() {
        return this.file;
    }

    public final int component2() {
        return this.version;
    }

    private final boolean component3() {
        return this.isCompressed;
    }

    @NotNull
    public final VersionedFile copy(@NotNull Path file, int version, boolean isCompressed) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new VersionedFile(file, version, isCompressed);
    }

    public static /* synthetic */ VersionedFile copy$default(VersionedFile versionedFile, Path path, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            path = versionedFile.file;
        }
        if ((n2 & 2) != 0) {
            n = versionedFile.version;
        }
        if ((n2 & 4) != 0) {
            bl = versionedFile.isCompressed;
        }
        return versionedFile.copy(path, n, bl);
    }

    @NotNull
    public String toString() {
        return "VersionedFile(file=" + this.file + ", version=" + this.version + ", isCompressed=" + this.isCompressed + ")";
    }

    public int hashCode() {
        int result = ((Object)this.file).hashCode();
        result = result * 31 + Integer.hashCode(this.version);
        result = result * 31 + Boolean.hashCode(this.isCompressed);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionedFile)) {
            return false;
        }
        VersionedFile versionedFile = (VersionedFile)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)versionedFile.file)) {
            return false;
        }
        if (this.version != versionedFile.version) {
            return false;
        }
        return this.isCompressed == versionedFile.isCompressed;
    }

    @JvmOverloads
    public VersionedFile(@NotNull Path file, int version) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(file, version, false, 4, null);
    }

    @JvmOverloads
    public final <T> void writeList(@NotNull Collection<? extends T> data, @NotNull Class<T> itemClass) throws IOException {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        VersionedFile.writeList$default(this, data, itemClass, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final <T> List<T> readList(@NotNull Class<T> itemClass, @NotNull ReadConfiguration configuration) throws IOException, SerializationException {
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return VersionedFile.readList$default(this, itemClass, configuration, false, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final <T> List<T> readList(@NotNull Class<T> itemClass) throws IOException, SerializationException {
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        return VersionedFile.readList$default(this, itemClass, null, false, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final <T> T read(@NotNull Class<T> objectClass) throws IOException, SerializationException {
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        return (T)VersionedFile.read$default(this, objectClass, null, 2, null);
    }
}

