/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.JdomSerializer;
import com.intellij.configurationStore.XmlSerializerKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.xml.KotlinAwareBeanBinding;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.JdomAdapter;
import com.intellij.util.xmlb.RootBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J3\u0010\u0006\u001a\u0004\u0018\u00010\u0007\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016JA\u0010\u0014\u001a\u0002H\b\"\u0004\b\u0000\u0010\b\"\b\b\u0001\u0010\u0015*\u00020\t2\u0006\u0010\u0016\u001a\u0002H\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\b0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u001c\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0018H\u0016J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J)\u0010\u0014\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010!\u001a\u00020\"2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0018H\u0016\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Lcom/intellij/configurationStore/JdomSerializerImpl;", "Lcom/intellij/configurationStore/JdomSerializer;", "<init>", "()V", "getDefaultSerializationFilter", "Lcom/intellij/util/xmlb/SkipDefaultsSerializationFilter;", "serialize", "Lorg/jdom/Element;", "T", "", "bean", "filter", "Lcom/intellij/util/xmlb/SerializationFilter;", "createElementIfEmpty", "", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/SerializationFilter;Z)Lorg/jdom/Element;", "serializeObjectInto", "", "obj", "target", "deserialize", "E", "element", "clazz", "Ljava/lang/Class;", "adapter", "Lcom/intellij/util/xmlb/DomAdapter;", "(Ljava/lang/Object;Ljava/lang/Class;Lcom/intellij/util/xmlb/DomAdapter;)Ljava/lang/Object;", "clearSerializationCaches", "getBeanBinding", "Lcom/intellij/util/xmlb/BeanBinding;", "aClass", "deserializeInto", "url", "Ljava/net/URL;", "(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", "intellij.platform.objectSerializer"})
final class JdomSerializerImpl
implements JdomSerializer {
    @NotNull
    public SkipDefaultsSerializationFilter getDefaultSerializationFilter() {
        return XmlSerializerKt.access$doGetDefaultSerializationFilter();
    }

    @Nullable
    public <T> Element serialize(@NotNull T bean, @Nullable SerializationFilter filter, boolean createElementIfEmpty) {
        Intrinsics.checkNotNullParameter(bean, (String)"bean");
        try {
            Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(bean.getClass());
            if (binding instanceof BeanBinding) {
                return ((BeanBinding)binding).serialize(bean, createElementIfEmpty, filter);
            }
            Intrinsics.checkNotNull((Object)binding, (String)"null cannot be cast to non-null type com.intellij.util.xmlb.RootBinding");
            Element element = ((RootBinding)binding).serialize(bean, filter);
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jdom.Element");
            return element;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Can't serialize instance of " + bean.getClass(), (Throwable)e);
        }
    }

    public void serializeObjectInto(@NotNull Object obj2, @NotNull Element target, @Nullable SerializationFilter filter) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (obj2 instanceof Element) {
            Iterator attributeIterator;
            Iterator iterator;
            Iterator iterator2 = iterator = ((Element)obj2).getChildren().iterator();
            while (iterator2.hasNext()) {
                Element child = (Element)iterator2.next();
                iterator.remove();
                target.addContent(child);
            }
            Iterator iterator3 = attributeIterator = ((Element)obj2).getAttributes().iterator();
            while (iterator3.hasNext()) {
                Attribute attribute = (Attribute)iterator3.next();
                attributeIterator.remove();
                target.setAttribute(attribute);
            }
            return;
        }
        Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(obj2.getClass());
        Intrinsics.checkNotNull((Object)binding, (String)"null cannot be cast to non-null type com.intellij.serialization.xml.KotlinAwareBeanBinding");
        KotlinAwareBeanBinding beanBinding = (KotlinAwareBeanBinding)binding;
        SerializationFilter serializationFilter = filter;
        if (serializationFilter == null) {
            serializationFilter = (SerializationFilter)XmlSerializerKt.access$doGetDefaultSerializationFilter();
        }
        beanBinding.serializeProperties(obj2, target, serializationFilter);
    }

    public <T, E> T deserialize(@NotNull E element, @NotNull Class<T> clazz, @NotNull DomAdapter<E> adapter) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        if (clazz == Element.class && adapter == JdomAdapter.INSTANCE) {
            return (T)element;
        }
        try {
            return (T)XmlSerializerKt.access$getSerializer$p().getRootBinding(clazz, clazz).deserialize(null, element, adapter);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + clazz.getName(), (Throwable)e);
        }
    }

    public void clearSerializationCaches() {
        XmlSerializerKt.clearBindingCache();
    }

    @NotNull
    public <T> BeanBinding getBeanBinding(@NotNull Class<T> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(aClass, aClass);
        Intrinsics.checkNotNull((Object)binding, (String)"null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
        return (BeanBinding)binding;
    }

    public void deserializeInto(@NotNull Object obj2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        try {
            Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(obj2.getClass());
            Intrinsics.checkNotNull((Object)binding, (String)"null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
            ((BeanBinding)binding).deserializeInto(obj2, element);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException((Throwable)e);
        }
    }

    public <T> T deserialize(@NotNull URL url, @NotNull Class<T> aClass) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        try {
            Element element = JDOMUtil.load((InputStream)URLUtil.openStream((URL)url));
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            return this.deserialize(element, aClass, (DomAdapter)JdomAdapter.INSTANCE);
        }
        catch (IOException e) {
            throw new XmlSerializationException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new XmlSerializationException((Throwable)e);
        }
    }
}

