/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.Binding;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.WriteContext;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\u00052\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/serialization/Int2IntMapBinding;", "Lcom/intellij/serialization/Binding;", "<init>", "()V", "serialize", "", "obj", "", "context", "Lcom/intellij/serialization/WriteContext;", "deserialize", "hostObject", "property", "Lcom/intellij/serialization/MutableAccessor;", "Lcom/intellij/serialization/ReadContext;", "doRead", "reader", "Lcom/amazon/ion/IonReader;", "Lcom/intellij/serialization/ValueReader;", "size", "", "result", "Lit/unimi/dsi/fastutil/ints/Int2IntMap;", "readMap", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "intellij.platform.objectSerializer"})
@SourceDebugExtension(value={"SMAP\nInt2IntMapBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Int2IntMapBinding.kt\ncom/intellij/serialization/Int2IntMapBinding\n+ 2 ion.kt\ncom/intellij/serialization/IonKt\n*L\n1#1,95:1\n9#2,4:96\n15#2,4:100\n15#2,4:104\n*S KotlinDebug\n*F\n+ 1 Int2IntMapBinding.kt\ncom/intellij/serialization/Int2IntMapBinding\n*L\n18#1:96,4\n59#1:100,4\n87#1:104,4\n*E\n"})
public final class Int2IntMapBinding
implements Binding {
    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Int2IntMap map = (Int2IntMap)obj2;
        IonWriter writer = context.writer;
        if (context.filter.getSkipEmptyMap() && map.isEmpty()) {
            writer.writeInt(0L);
            return;
        }
        IonWriter $this$list$iv = writer;
        boolean $i$f$list = false;
        $this$list$iv.stepIn(IonType.LIST);
        boolean bl = false;
        writer.writeInt((long)map.size());
        if (context.configuration.orderMapEntriesByKeys) {
            int[] keys = ((IntSet)map.keySet()).toIntArray();
            Intrinsics.checkNotNull((Object)keys);
            ArraysKt.sort((int[])keys);
            for (int key : keys) {
                writer.writeInt((long)key);
                writer.writeInt((long)map.get(key));
            }
        } else {
            ObjectSet entrySet = map.int2IntEntrySet();
            ObjectIterator objectIterator = entrySet.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            ObjectIterator objectIterator2 = objectIterator;
            while (objectIterator2.hasNext()) {
                Int2IntMap.Entry entry = (Int2IntMap.Entry)objectIterator2.next();
                writer.writeInt((long)entry.getIntKey());
                writer.writeInt((long)entry.getIntValue());
            }
        }
        $this$list$iv.stepOut();
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getReader().getType() == IonType.NULL) {
            property.set(hostObject, null);
            return;
        }
        Int2IntMap result = (Int2IntMap)property.readUnsafe(hostObject);
        if (result == null) {
            property.set(hostObject, (Object)this.readMap(context.getReader()));
            return;
        }
        result.clear();
        IonReader reader = context.getReader();
        if (reader.getType() == IonType.INT) {
            ObjectSerializerKt.getLOG().assertTrue(reader.intValue() == 0);
        } else {
            IonReader $this$list$iv = reader;
            boolean $i$f$list = false;
            $this$list$iv.stepIn();
            boolean bl = false;
            reader.next();
            int size = reader.intValue();
            this.doRead(reader, size, result);
            Unit result$iv = Unit.INSTANCE;
            $this$list$iv.stepOut();
        }
    }

    private final void doRead(IonReader reader, int size, Int2IntMap result) {
        int n = 0;
        while (n < size) {
            int it = n++;
            boolean bl = false;
            reader.next();
            int k = reader.intValue();
            reader.next();
            int v = reader.intValue();
            result.put(k, v);
        }
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.readMap(context.getReader());
    }

    private final Int2IntOpenHashMap readMap(IonReader reader) {
        if (reader.getType() == IonType.INT) {
            ObjectSerializerKt.getLOG().assertTrue(reader.intValue() == 0);
            return new Int2IntOpenHashMap();
        }
        IonReader $this$list$iv = reader;
        boolean $i$f$list = false;
        $this$list$iv.stepIn();
        boolean bl = false;
        reader.next();
        int size = reader.intValue();
        Int2IntOpenHashMap result = new Int2IntOpenHashMap(size);
        this.doRead(reader, size, (Int2IntMap)result);
        Int2IntOpenHashMap result$iv = result;
        $this$list$iv.stepOut();
        return result$iv;
    }
}

