/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.ScalarProperty;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.stateProperties.ObjectStateStoredPropertyBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\u00020\u0004B\u001f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001f\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/serialization/stateProperties/EnumStoredProperty;", "T", "", "Lcom/intellij/serialization/stateProperties/ObjectStateStoredPropertyBase;", "Lcom/intellij/openapi/components/ScalarProperty;", "defaultValue", "clazz", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Enum;Ljava/lang/Class;)V", "Ljava/lang/Enum;", "getClazz", "()Ljava/lang/Class;", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "isEqualToDefault", "", "getModificationCount", "", "setValue", "", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "newValue", "(Lcom/intellij/openapi/components/BaseState;Ljava/lang/Enum;)V", "parseAndSetValue", "rawValue", "", "intellij.platform.objectSerializer"})
@ApiStatus.Internal
public final class EnumStoredProperty<T extends Enum<?>>
extends ObjectStateStoredPropertyBase<T>
implements ScalarProperty {
    @Nullable
    private final T defaultValue;
    @NotNull
    private final Class<T> clazz;

    public EnumStoredProperty(@Nullable T defaultValue, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        super(defaultValue);
        this.defaultValue = defaultValue;
        this.clazz = clazz;
    }

    @NotNull
    public final Class<T> getClazz() {
        return this.clazz;
    }

    @Override
    @NotNull
    public JsonSchemaType getJsonType() {
        return JsonSchemaType.STRING;
    }

    public boolean isEqualToDefault() {
        return this.getValue() == this.defaultValue;
    }

    public long getModificationCount() {
        return 0L;
    }

    @Override
    public void setValue(@NotNull BaseState thisRef, @Nullable T newValue) {
        T v;
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        T t = newValue;
        if (t == null) {
            t = v = this.defaultValue;
        }
        if (this.getValue() != v) {
            thisRef.intIncrementModificationCount();
            this.setValue(v);
        }
    }

    public void parseAndSetValue(@Nullable String rawValue) {
        if (rawValue == null) {
            this.setValue(this.defaultValue);
        } else {
            Enum enum_ = (Enum)ClassUtil.stringToEnum((String)rawValue, this.clazz, (boolean)true);
            if (enum_ == null) {
                enum_ = this.defaultValue;
            }
            this.setValue(enum_);
        }
    }
}

