/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.pratt;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.pratt.MutableMarker;
import com.intellij.platform.pratt.PrattBuilder;
import com.intellij.platform.pratt.PrattBundle;
import com.intellij.platform.pratt.PrattRegistry;
import com.intellij.platform.pratt.TokenParser;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrattBuilderImpl
extends PrattBuilder {
    private final PsiBuilder myBuilder;
    private final PrattBuilder myParentBuilder;
    private final PrattRegistry myRegistry;
    private final LinkedList<IElementType> myLeftSiblings = new LinkedList();
    private boolean myParsingStarted;
    private @NlsContexts.ParsingError String myExpectedMessage;
    private int myPriority = Integer.MIN_VALUE;
    private MutableMarker myStartMarker;

    private PrattBuilderImpl(PsiBuilder builder, PrattBuilder parent, PrattRegistry registry) {
        this.myBuilder = builder;
        this.myParentBuilder = parent;
        this.myRegistry = registry;
    }

    static PrattBuilder createBuilder(PsiBuilder builder, PrattRegistry registry) {
        return new PrattBuilderImpl(builder, null, registry);
    }

    @Override
    public PrattBuilder expecting(@NlsContexts.ParsingError String expectedMessage) {
        this.myExpectedMessage = expectedMessage;
        return this;
    }

    @Override
    public PrattBuilder withLowestPriority(int priority) {
        this.myPriority = priority;
        return this;
    }

    @Override
    public Lexer getLexer() {
        return ((PsiBuilderImpl)this.myBuilder).getLexer();
    }

    @Override
    public void setTokenTypeRemapper(@Nullable ITokenTypeRemapper remapper) {
        this.myBuilder.setTokenTypeRemapper(remapper);
    }

    @Override
    public MutableMarker mark() {
        return new MutableMarker(this.myLeftSiblings, this.myBuilder.mark(), this.myLeftSiblings.size());
    }

    @Override
    @Nullable
    public IElementType parse() {
        this.checkParsed();
        return this.myLeftSiblings.size() != 1 ? null : this.myLeftSiblings.getLast();
    }

    @Override
    protected PrattBuilder createChildBuilder() {
        assert (this.myParsingStarted);
        return new PrattBuilderImpl(this.myBuilder, this, this.myRegistry){

            @Override
            protected void doParse() {
                super.doParse();
                PrattBuilderImpl.this.myLeftSiblings.addAll(this.getResultTypes());
            }
        };
    }

    protected void doParse() {
        if (this.isEof()) {
            this.error(this.myExpectedMessage != null ? this.myExpectedMessage : PrattBundle.message("unexpected.eof", new Object[0]));
            return;
        }
        TokenParser parser = this.findParser();
        if (parser == null) {
            this.error(this.myExpectedMessage != null ? this.myExpectedMessage : PrattBundle.message("unexpected.token", new Object[0]));
            return;
        }
        this.myStartMarker = this.mark();
        while (!this.isEof()) {
            int startOffset = this.myBuilder.getCurrentOffset();
            if (!parser.parseToken(this)) break;
            assert (startOffset < this.myBuilder.getCurrentOffset()) : "Endless loop on " + String.valueOf(this.getTokenType());
            parser = this.findParser();
            if (parser != null) continue;
            break;
        }
        this.myStartMarker.drop();
    }

    @Nullable
    private TokenParser findParser() {
        IElementType tokenType = this.getTokenType();
        for (PrattRegistry.ParserData parserData : this.myRegistry.getParsers(tokenType)) {
            if (parserData.priority() <= this.myPriority || !parserData.pattern().accepts(this)) continue;
            return parserData.parser();
        }
        return null;
    }

    @Override
    public void advance() {
        this.myLeftSiblings.addLast(this.getTokenType());
        this.myBuilder.advanceLexer();
    }

    @Override
    public void error(@NlsContexts.ParsingError @NotNull String errorText) {
        if (errorText == null) {
            PrattBuilderImpl.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.error(errorText);
        marker.drop();
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    @Override
    @Nullable
    public String getTokenText() {
        return this.myBuilder.getTokenText();
    }

    @Override
    public void reduce(@NotNull IElementType type) {
        if (type == null) {
            PrattBuilderImpl.$$$reportNull$$$0(1);
        }
        this.myStartMarker.finish(type);
        this.myStartMarker = this.myStartMarker.precede();
    }

    @Override
    @NotNull
    public List<IElementType> getResultTypes() {
        this.checkParsed();
        LinkedList<IElementType> linkedList = this.myLeftSiblings;
        if (linkedList == null) {
            PrattBuilderImpl.$$$reportNull$$$0(2);
        }
        return linkedList;
    }

    private void checkParsed() {
        if (!this.myParsingStarted) {
            this.myParsingStarted = true;
            this.doParse();
        }
    }

    @Override
    public PrattBuilder getParent() {
        return this.myParentBuilder;
    }

    @Override
    public int getPriority() {
        return this.myPriority;
    }

    @Override
    public int getCurrentOffset() {
        return this.myBuilder.getCurrentOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/pratt/PrattBuilderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/pratt/PrattBuilderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

