/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.module.LoadedModuleDescription;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ModuleGrouperBase;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/module/impl/ExplicitModuleGrouper;", "Lcom/intellij/openapi/module/impl/ModuleGrouperBase;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/ModifiableModuleModel;)V", "getGroupPath", "", "", "module", "Lcom/intellij/openapi/module/Module;", "description", "Lcom/intellij/openapi/module/ModuleDescription;", "getShortenedNameByFullModuleName", "name", "parentGroupName", "getGroupPathByModuleName", "getModuleAsGroupPath", "", "compactGroupNodes", "", "getCompactGroupNodes", "()Z", "intellij.platform.projectModel.impl"})
final class ExplicitModuleGrouper
extends ModuleGrouperBase {
    public ExplicitModuleGrouper(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, model);
    }

    @NotNull
    public List<String> getGroupPath(@NotNull Module module) {
        List list;
        String[] path;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (path != null) {
            String[] stringArray = path = this.getModel() != null ? this.getModel().getModuleGroupPath(module) : ModuleManager.Companion.getInstance(this.getProject()).getModuleGroupPath(module);
            list = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public List<String> getGroupPath(@NotNull ModuleDescription description) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        ModuleDescription moduleDescription = description;
        if (moduleDescription instanceof LoadedModuleDescription) {
            Module module = ((LoadedModuleDescription)description).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            list = this.getGroupPath(module);
        } else if (moduleDescription instanceof UnloadedModuleDescription) {
            List<String> list2 = ((UnloadedModuleDescription)description).getGroupPath();
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getGroupPath(...)");
        } else {
            throw new IllegalArgumentException(description.getClass().getName());
        }
        return list;
    }

    @NotNull
    public String getShortenedNameByFullModuleName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return name;
    }

    @NotNull
    public String getShortenedNameByFullModuleName(@NotNull String name, @Nullable String parentGroupName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return name;
    }

    @NotNull
    public List<String> getGroupPathByModuleName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return CollectionsKt.emptyList();
    }

    @Nullable
    public Void getModuleAsGroupPath(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return null;
    }

    @Nullable
    public Void getModuleAsGroupPath(@NotNull ModuleDescription description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return null;
    }

    public boolean getCompactGroupNodes() {
        return false;
    }
}

