/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.platform.workspace.jps.entities.ProjectSettingsEntity;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.jps.entities.SdkRoot;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.workspaceModel.core.fileIndex.DependencyDescription;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributorEnforcer;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.JvmPackageRootDataInternal;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleOrLibrarySourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.ide.WsmSingletonEntityUtils;
import com.intellij.workspaceModel.ide.impl.legacyBridge.sdk.SdkBridgeImplKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/SdkEntityFileIndexContributor;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "Lcom/intellij/platform/workspace/jps/entities/SdkEntity;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PlatformInternalWorkspaceFileIndexContributor;", "<init>", "()V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "registerFileSets", "", "entity", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "dependenciesOnOtherEntities", "", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription;", "getDependenciesOnOtherEntities", "()Ljava/util/List;", "isProjectSdk", "", "SdkSourceRootFileSetData", "SdkRootFileSetData", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nSdkEntityFileIndexContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkEntityFileIndexContributor.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/SdkEntityFileIndexContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1761#2,3:66\n*S KotlinDebug\n*F\n+ 1 SdkEntityFileIndexContributor.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/SdkEntityFileIndexContributor\n*L\n29#1:66,3\n*E\n"})
public final class SdkEntityFileIndexContributor
implements WorkspaceFileIndexContributor<SdkEntity>,
PlatformInternalWorkspaceFileIndexContributor {
    @Override
    @NotNull
    public Class<SdkEntity> getEntityClass() {
        return SdkEntity.class;
    }

    @Override
    public void registerFileSets(@NotNull SdkEntity entity, @NotNull WorkspaceFileSetRegistrar registrar, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        WorkspaceFileSetData compiledRootsData = null;
        WorkspaceFileSetData sourceRootFileSetData = null;
        if (this.isProjectSdk(entity, storage)) {
            compiledRootsData = new SdkRootFileSetData(entity.getSymbolicId());
            sourceRootFileSetData = new SdkSourceRootFileSetData(entity.getSymbolicId());
        } else {
            boolean enforced;
            block8: {
                Iterable $this$any$iv = WorkspaceFileIndexContributorEnforcer.Companion.getEP_NAME().getExtensionsIfPointIsRegistered();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        WorkspaceFileIndexContributorEnforcer it = (WorkspaceFileIndexContributorEnforcer)element$iv;
                        boolean bl = false;
                        if (!it.shouldContribute((WorkspaceEntity)entity, storage)) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = enforced = false;
                }
            }
            if (!enforced && !storage.hasReferrers((SymbolicEntityId)entity.getSymbolicId())) {
                return;
            }
            compiledRootsData = new SdkRootFileSetData(entity.getSymbolicId());
            sourceRootFileSetData = new SdkSourceRootFileSetData(entity.getSymbolicId());
        }
        for (SdkRoot root : entity.getRoots()) {
            String string = root.getType().getName();
            OrderRootType orderRootType = OrderRootType.CLASSES;
            Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"CLASSES");
            if (Intrinsics.areEqual((Object)string, (Object)SdkBridgeImplKt.getCustomName(orderRootType))) {
                registrar.registerFileSet(root.getUrl(), WorkspaceFileKind.EXTERNAL, (WorkspaceEntity)entity, compiledRootsData);
                continue;
            }
            OrderRootType orderRootType2 = OrderRootType.SOURCES;
            Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"SOURCES");
            if (!Intrinsics.areEqual((Object)string, (Object)SdkBridgeImplKt.getCustomName(orderRootType2))) continue;
            registrar.registerFileSet(root.getUrl(), WorkspaceFileKind.EXTERNAL_SOURCE, (WorkspaceEntity)entity, sourceRootFileSetData);
        }
    }

    @Override
    @NotNull
    public List<DependencyDescription<SdkEntity>> getDependenciesOnOtherEntities() {
        return CollectionsKt.listOf(new DependencyDescription.OnReference(SdkId.class));
    }

    private final boolean isProjectSdk(SdkEntity entity, EntityStorage storage) {
        ProjectSettingsEntity setting;
        ProjectSettingsEntity projectSettingsEntity = setting = WsmSingletonEntityUtils.INSTANCE.getSingleEntity(storage, ProjectSettingsEntity.class);
        return Intrinsics.areEqual((Object)(projectSettingsEntity != null ? projectSettingsEntity.getProjectSdk() : null), (Object)entity.getSymbolicId());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/SdkEntityFileIndexContributor$SdkRootFileSetData;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/JvmPackageRootDataInternal;", "sdkId", "Lcom/intellij/platform/workspace/jps/entities/SdkId;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/SdkId;)V", "getSdkId$intellij_platform_projectModel_impl", "()Lcom/intellij/platform/workspace/jps/entities/SdkId;", "packagePrefix", "", "getPackagePrefix", "()Ljava/lang/String;", "intellij.platform.projectModel.impl"})
    public static class SdkRootFileSetData
    implements JvmPackageRootDataInternal {
        @NotNull
        private final SdkId sdkId;
        @NotNull
        private final String packagePrefix;

        public SdkRootFileSetData(@NotNull SdkId sdkId) {
            Intrinsics.checkNotNullParameter((Object)sdkId, (String)"sdkId");
            this.sdkId = sdkId;
            this.packagePrefix = "";
        }

        @NotNull
        public final SdkId getSdkId$intellij_platform_projectModel_impl() {
            return this.sdkId;
        }

        @Override
        @NotNull
        public String getPackagePrefix() {
            return this.packagePrefix;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/SdkEntityFileIndexContributor$SdkSourceRootFileSetData;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/SdkEntityFileIndexContributor$SdkRootFileSetData;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ModuleOrLibrarySourceRootData;", "sdkId", "Lcom/intellij/platform/workspace/jps/entities/SdkId;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/SdkId;)V", "intellij.platform.projectModel.impl"})
    public static class SdkSourceRootFileSetData
    extends SdkRootFileSetData
    implements ModuleOrLibrarySourceRootData {
        public SdkSourceRootFileSetData(@NotNull SdkId sdkId) {
            Intrinsics.checkNotNullParameter((Object)sdkId, (String)"sdkId");
            super(sdkId);
        }
    }
}

